<?php
/**
 * Template part for displaying posts search
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Essence News
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="single-card-container grid-card">
		<div class="single-card-image">
			<?php essence_news_post_thumbnail(); ?>
		</div>
		<div class="single-card-detail">
			<?php essence_news_categories_list(); ?>
			<?php
				if ( is_singular() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h2 class="card-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;
			?>
			<div class="post-exerpt">
				<?php echo wp_kses_post( wp_trim_words( get_the_excerpt(), get_theme_mod( 'essence_news_excerpt_length', 15 ) ) ); ?>
			</div><!-- post-exerpt -->
			<?php
			if ( 'post' === get_post_type() ) :
				?>
				<div class="card-meta">
					<?php
						essence_news_posted_by();
						essence_news_posted_on();
						essence_news_relative_time();
					?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->
