<?php
/**
 * Frontpage Editor Choice Section.
 *
 * @package Essence News
 */

// Editor Choice Section.
$editor_choice_section = get_theme_mod( 'essence_news_editor_choice_section_enable', false );

if ( false === $editor_choice_section ) {
	return;
}

$content_ids                = array();
$editor_choice_content_type = get_theme_mod( 'essence_news_editor_choice_content_type', 'post' );

if ( $editor_choice_content_type === 'post' ) {

	for ( $i = 1; $i <= 6; $i++ ) {
		$content_ids[] = get_theme_mod( 'essence_news_editor_choice_post_' . $i );
	}

	$args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 6),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $content_ids ) ) ) {
		$args['post__in'] = array_filter( $content_ids );
		$args['orderby']  = 'post__in';
	} else {
		$args['orderby'] = 'date';
	}

} else {
	$cat_content_id = get_theme_mod( 'essence_news_editor_choice_category' );
	$args           = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 6),
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) {
	$section_title = get_theme_mod( 'essence_news_editor_choice_title', __( 'Editor Choice', 'essence-news' ) );
	?>
	
	<section id="essence_news_editor_choice_section" class="blog-editors-choice section-divider">
		<div class="site-container-width">
			<?php if ( ! empty( $section_title ) ) : ?>
				<div class="header-title">
					<h3 class="section-title"><?php echo esc_html( $section_title ); ?></h3>
				</div>
			<?php endif; ?>
			<div class="container-wrap">
				<?php
				while ( $query->have_posts() ) :
					$query->the_post();
					?>
					<div class="single-card-container grid-card">
						<div class="single-card-image">
							<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
						</div>
						<div class="single-card-detail">
							<?php essence_news_categories_list(); ?>
							<h3 class="card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
							<div class="post-exerpt">
								<p><?php echo wp_kses_post( wp_trim_words( get_the_content(), 20 ) ); ?></p>
							</div>
							<div class="card-meta">
								<?php
									essence_news_posted_by();
									essence_news_posted_on();
									essence_news_relative_time();
								?>
							</div>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
	</section>

	<?php
}
