<?php $banner_posts_title = get_theme_mod( 'essence_news_banner_posts_title', __( 'Main News', 'essence-news' ) ); ?>
<div class="banner-posts">
	<?php if ( ! empty( $banner_posts_title ) ) { ?>
		<div class="header-title">
			<h3 class="section-title"><?php echo esc_html( $banner_posts_title ); ?></h3>
		</div>
	<?php } ?>
	<div class="banner-posts-wrapper">
		<?php
		$banner_posts_query = new WP_Query( $banner_posts_args );
		if ( $banner_posts_query->have_posts() ) {
			while ( $banner_posts_query->have_posts() ) :
				$banner_posts_query->the_post();
				?>
				<div class="single-card-container tile-card">
					<div class="single-card-image">
						<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
					</div>
					<div class="single-card-detail">
						<?php essence_news_categories_list(); ?>
						<h3 class="card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						<div class="card-meta">
							<?php
								essence_news_posted_by();
								essence_news_posted_on();
								essence_news_relative_time();
							?>
						</div>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>