<?php
/**
 * Frontpage Banner Section.
 *
 * @package Essence News
 */

// Banner Section.
$banner_section = get_theme_mod( 'essence_news_banner_section_enable', false );

if ( false === $banner_section ) {
	return;
}

$daily_news_content_ids    = $banner_posts_content_ids = $top_stories_content_ids = array();
$daily_news_content_type   = get_theme_mod( 'essence_news_daily_news_content_type', 'post' );
$banner_posts_content_type = get_theme_mod( 'essence_news_banner_posts_content_type', 'post' );
$top_stories_content_type  = get_theme_mod( 'essence_news_banner_top_stories_content_type', 'post' );

if ( $daily_news_content_type === 'post' ) {

	for ( $i = 1; $i <= 3; $i++ ) {
		$daily_news_content_ids[] = get_theme_mod( 'essence_news_daily_news_post_' . $i );
	}

	$daily_news_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 3),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $daily_news_content_ids ) ) ) {
		$daily_news_args['post__in'] = array_filter( $daily_news_content_ids );
		$daily_news_args['orderby']  = 'post__in';
	} else {
		$daily_news_args['orderby'] = 'date';
	}

} else {
	$cat_content_id = get_theme_mod( 'essence_news_daily_news_category' );
	$daily_news_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 3),
	);
}

if ( $banner_posts_content_type === 'post' ) {

	for ( $i = 1; $i <= 2; $i++ ) {
		$banner_posts_content_ids[] = get_theme_mod( 'essence_news_banner_posts_post_' . $i );
	}

	$banner_posts_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 2 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $banner_posts_content_ids ) ) ) {
		$banner_posts_args['post__in'] = array_filter( $banner_posts_content_ids );
		$banner_posts_args['orderby']  = 'post__in';
	} else {
		$banner_posts_args['orderby'] = 'date';
	}

} else {
	$cat_content_id     = get_theme_mod( 'essence_news_banner_posts_category' );
	$banner_posts_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 2 ),
	);
}

if ( $top_stories_content_type === 'post' ) {

	for ( $i = 1; $i <= 6; $i++ ) {
		$top_stories_content_ids[] = get_theme_mod( 'essence_news_banner_top_stories_post_' . $i );
	}

	$top_stories_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 6 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $top_stories_content_ids ) ) ) {
		$top_stories_args['post__in'] = array_filter( $top_stories_content_ids );
		$top_stories_args['orderby']  = 'post__in';
	} else {
		$top_stories_args['orderby'] = 'date';
	}

} else {
	$cat_content_id   = get_theme_mod( 'essence_news_banner_top_stories_category' );
	$top_stories_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 6 ),
	);
}

?>

<section id="essence_news_banner_section" class="banner-section banner-layout-1">
	<div class="site-container-width">
		<div class="banner-section-wrapper">
			
			<?php
			require get_template_directory() . '/inc/frontpage-sections/banner/banner-posts.php';
			require get_template_directory() . '/inc/frontpage-sections/banner/daily-news.php';
			require get_template_directory() . '/inc/frontpage-sections/banner/top-stories.php';
			?>
			
		</div>
	</div>
</section>