<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'essence_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'essence-news' ),
		'panel' => 'essence_news_theme_options_panel',
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'essence_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'essence-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'essence_news_related_posts_title',
	array(
		'label'    => esc_html__( 'Related Posts Title', 'essence-news' ),
		'section'  => 'essence_news_single_page_options',
		'settings' => 'essence_news_related_posts_title',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'essence_news_related_posts_title',
		array(
			'selector'            => '.theme-wrapper h2.related-title',
			'settings'            => 'essence_news_related_posts_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}
