<?php
/**
 * Sidebar settings
 */

$wp_customize->add_section(
	'essence_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'essence-news' ),
		'panel' => 'essence_news_theme_options_panel',
	)
);

// Sidebar Option - Archive Sidebar Position.
$wp_customize->add_setting(
	'essence_news_archive_sidebar_position',
	array(
		'sanitize_callback' => 'essence_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'essence_news_archive_sidebar_position',
	array(
		'label'   => esc_html__( 'Archive Sidebar Position', 'essence-news' ),
		'section' => 'essence_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'essence-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'essence-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'essence_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'essence_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'essence_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'essence-news' ),
		'section' => 'essence_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'essence-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'essence-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'essence_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'essence_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'essence_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'essence-news' ),
		'section' => 'essence_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'essence-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'essence-news' ),
		),
	)
);
