<?php

$wp_customize->add_section(
	'essence_news_posts_meta_options',
	array(
		'title' => esc_html__( 'Post Meta Options', 'essence-news' ),
		'panel' => 'essence_news_theme_options_panel',
	)
);

// Enable post category setting.
$wp_customize->add_setting(
	'essence_news_enable_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_enable_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'essence-news' ),
			'settings' => 'essence_news_enable_category',
			'section'  => 'essence_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post author setting.
$wp_customize->add_setting(
	'essence_news_enable_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_enable_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'essence-news' ),
			'settings' => 'essence_news_enable_author',
			'section'  => 'essence_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post date setting.
$wp_customize->add_setting(
	'essence_news_enable_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_enable_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'essence-news' ),
			'settings' => 'essence_news_enable_date',
			'section'  => 'essence_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable relative time setting.
$wp_customize->add_setting(
	'essence_news_enable_relative_time',
	array(
		'default'           => true,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_enable_relative_time',
		array(
			'label'    => esc_html__( 'Enable Relative Time', 'essence-news' ),
			'settings' => 'essence_news_enable_relative_time',
			'section'  => 'essence_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post tag setting.
$wp_customize->add_setting(
	'essence_news_enable_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_enable_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'essence-news' ),
			'settings' => 'essence_news_enable_tag',
			'section'  => 'essence_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);