<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'essence_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'essence-news' ),
		'panel' => 'essence_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'essence_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'essence-news' ),
			'settings' => 'essence_news_pagination_enable',
			'section'  => 'essence_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'essence_news_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'essence_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'essence_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'essence-news' ),
		'section'         => 'essence_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'essence-news' ),
			'numeric' => __( 'Numeric', 'essence-news' ),
		),
		'active_callback' => 'essence_news_pagination_enabled',
	)
);

/*========================Active Callback==============================*/
function essence_news_pagination_enabled( $control ) {
	return $control->manager->get_setting( 'essence_news_pagination_enable' )->value();
}
