<?php
/**
 * Header Options
 */

// Header Options.
$wp_customize->add_section(
	'essence_news_header_section',
	array(
		'title' => esc_html__( 'Header Options', 'essence-news' ),
		'panel' => 'essence_news_theme_options_panel',
	)
);

// Header Button label setting.
$wp_customize->add_setting(
	'essence_news_header_button_label',
	array(
		'default'           => __( 'Sign In', 'essence-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'essence_news_header_button_label',
	array(
		'label'    => esc_html__( 'Header Button Label', 'essence-news' ),
		'section'  => 'essence_news_header_section',
		'settings' => 'essence_news_header_button_label',
		'type'     => 'text',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'essence_news_header_button_label',
		array(
			'selector'            => '.header-button a',
			'settings'            => 'essence_news_header_button_label',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Header Button URL setting.
$wp_customize->add_setting(
	'essence_news_header_button_url',
	array(
		'default'           => '#',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'essence_news_header_button_url',
	array(
		'label'    => esc_html__( 'Header Button Link', 'essence-news' ),
		'section'  => 'essence_news_header_section',
		'settings' => 'essence_news_header_button_url',
		'type'     => 'url',
	)
);
