<?php
/**
 * Breadcrumb settings
 */

$wp_customize->add_section(
	'essence_news_breadcrumb_section',
	array(
		'title' => esc_html__( 'Breadcrumb Options', 'essence-news' ),
		'panel' => 'essence_news_theme_options_panel',
	)
);

// Breadcrumb enable setting.
$wp_customize->add_setting(
	'essence_news_breadcrumb_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_breadcrumb_enable',
		array(
			'label'    => esc_html__( 'Enable breadcrumb.', 'essence-news' ),
			'type'     => 'checkbox',
			'settings' => 'essence_news_breadcrumb_enable',
			'section'  => 'essence_news_breadcrumb_section',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'essence_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'essence_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'essence-news' ),
		'section'         => 'essence_news_breadcrumb_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'essence_news_breadcrumb_enable' )->value() );
		},
	)
);
