<?php
/**
 * Highlights Section
 */

$wp_customize->add_section(
	'essence_news_highlights_news_section',
	array(
		'title' => esc_html__( 'Highlights Section', 'essence-news' ),
		'panel' => 'essence_news_frontpage_panel',
	)
);

// Highlights News section enable settings.
$wp_customize->add_setting(
	'essence_news_highlights_news_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_highlights_news_section_enable',
		array(
			'label'    => esc_html__( 'Enable Highlights News Section', 'essence-news' ),
			'type'     => 'checkbox',
			'settings' => 'essence_news_highlights_news_section_enable',
			'section'  => 'essence_news_highlights_news_section',
		)
	)
);

// Highlights News title settings.
$wp_customize->add_setting(
	'essence_news_highlights_news_title',
	array(
		'default'           => __( 'Highlights News', 'essence-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'essence_news_highlights_news_title',
	array(
		'label'           => esc_html__( 'Section Title', 'essence-news' ),
		'section'         => 'essence_news_highlights_news_section',
		'active_callback' => 'essence_news_if_highlights_news_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'essence_news_highlights_news_title',
		array(
			'selector'            => '.recentpost h3.section-title',
			'settings'            => 'essence_news_highlights_news_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Highlights news content type settings.
$wp_customize->add_setting(
	'essence_news_highlights_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'essence_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'essence_news_highlights_news_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'essence-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'essence-news' ),
		'section'         => 'essence_news_highlights_news_section',
		'type'            => 'select',
		'active_callback' => 'essence_news_if_highlights_news_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'essence-news' ),
			'category' => esc_html__( 'Category', 'essence-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Highlights news post setting.
	$wp_customize->add_setting(
		'essence_news_highlights_news_post_' . $i,
		array(
			'sanitize_callback' => 'essence_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'essence_news_highlights_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'essence-news' ), $i ),
			'section'         => 'essence_news_highlights_news_section',
			'type'            => 'select',
			'choices'         => essence_news_get_post_choices(),
			'active_callback' => 'essence_news_highlights_news_section_content_type_post_enabled',
		)
	);

}

// Highlights news category setting.
$wp_customize->add_setting(
	'essence_news_highlights_news_category',
	array(
		'sanitize_callback' => 'essence_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'essence_news_highlights_news_category',
	array(
		'label'           => esc_html__( 'Category', 'essence-news' ),
		'section'         => 'essence_news_highlights_news_section',
		'type'            => 'select',
		'choices'         => essence_news_get_post_cat_choices(),
		'active_callback' => 'essence_news_highlights_news_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function essence_news_if_highlights_news_enabled( $control ) {
	return $control->manager->get_setting( 'essence_news_highlights_news_section_enable' )->value();
}
function essence_news_highlights_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'essence_news_highlights_news_content_type' )->value();
	return essence_news_if_highlights_news_enabled( $control ) && ( 'post' === $content_type );
}
function essence_news_highlights_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'essence_news_highlights_news_content_type' )->value();
	return essence_news_if_highlights_news_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'essence_news_highlights_news_title_text_partial' ) ) :
	// Title.
	function essence_news_highlights_news_title_text_partial() {
		return esc_html( get_theme_mod( 'essence_news_highlights_news_title' ) );
	}
endif;
