<?php
/**
 * Frontpage Customizer Settings
 *
 * @package Essence News
 *
 * Editor Choice Section
 */

$wp_customize->add_section(
	'essence_news_editor_choice_section',
	array(
		'title' => esc_html__( 'Editor Choice Section', 'essence-news' ),
		'panel' => 'essence_news_frontpage_panel',
	)
);

// Editor Choice section enable settings.
$wp_customize->add_setting(
	'essence_news_editor_choice_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'essence_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Essence_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'essence_news_editor_choice_section_enable',
		array(
			'label'    => esc_html__( 'Enable Editor Choice Section', 'essence-news' ),
			'type'     => 'checkbox',
			'settings' => 'essence_news_editor_choice_section_enable',
			'section'  => 'essence_news_editor_choice_section',
		)
	)
);

// Editor Choice title settings.
$wp_customize->add_setting(
	'essence_news_editor_choice_title',
	array(
		'default'           => __( 'Editor Choice', 'essence-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'essence_news_editor_choice_title',
	array(
		'label'           => esc_html__( 'Section Title', 'essence-news' ),
		'section'         => 'essence_news_editor_choice_section',
		'active_callback' => 'essence_news_if_editor_choice_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'essence_news_editor_choice_title',
		array(
			'selector'            => '.blog-editors-choice h3.section-title',
			'settings'            => 'essence_news_editor_choice_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// editor_choice content type settings.
$wp_customize->add_setting(
	'essence_news_editor_choice_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'essence_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'essence_news_editor_choice_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'essence-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'essence-news' ),
		'section'         => 'essence_news_editor_choice_section',
		'type'            => 'select',
		'active_callback' => 'essence_news_if_editor_choice_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'essence-news' ),
			'category' => esc_html__( 'Category', 'essence-news' ),
		),
	)
);

for ( $i = 1; $i <= 6; $i++ ) {
	// editor_choice post setting.
	$wp_customize->add_setting(
		'essence_news_editor_choice_post_' . $i,
		array(
			'sanitize_callback' => 'essence_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'essence_news_editor_choice_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'essence-news' ), $i ),
			'section'         => 'essence_news_editor_choice_section',
			'type'            => 'select',
			'choices'         => essence_news_get_post_choices(),
			'active_callback' => 'essence_news_editor_choice_section_content_type_post_enabled',
		)
	);

}

// editor_choice category setting.
$wp_customize->add_setting(
	'essence_news_editor_choice_category',
	array(
		'sanitize_callback' => 'essence_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'essence_news_editor_choice_category',
	array(
		'label'           => esc_html__( 'Category', 'essence-news' ),
		'section'         => 'essence_news_editor_choice_section',
		'type'            => 'select',
		'choices'         => essence_news_get_post_cat_choices(),
		'active_callback' => 'essence_news_editor_choice_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function essence_news_if_editor_choice_enabled( $control ) {
	return $control->manager->get_setting( 'essence_news_editor_choice_section_enable' )->value();
}
function essence_news_editor_choice_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'essence_news_editor_choice_content_type' )->value();
	return essence_news_if_editor_choice_enabled( $control ) && ( 'post' === $content_type );
}
function essence_news_editor_choice_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'essence_news_editor_choice_content_type' )->value();
	return essence_news_if_editor_choice_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'essence_news_editor_choice_title_text_partial' ) ) :
	// Title.
	function essence_news_editor_choice_title_text_partial() {
		return esc_html( get_theme_mod( 'essence_news_editor_choice_title' ) );
	}
endif;
