<?php
/**
 * Template part for displaying posts
 *
 * @package Travel Tourist
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="card-item card-blog-post">
		<?php
			// Get the post ID
			$post_id = get_the_ID();

			// Check if there are audio embedded in the post content
			$post = get_post($post_id);
			$travel_tourist_content = do_shortcode(apply_filters('the_content', $post->post_content));
			$travel_tourist_embeds = get_media_embedded_in_content($travel_tourist_content);

			// Track displayed audio embeds
			$travel_tourist_displayed_embeds = [];
			
			// Check if not in a singular view
			if (!is_singular() && !empty($travel_tourist_embeds)) {
				foreach ($travel_tourist_embeds as $travel_tourist_embed) {
					if (strpos($travel_tourist_embed, 'audio') !== false && !in_array($travel_tourist_embed, $travel_tourist_displayed_embeds)) {
						$travel_tourist_displayed_embeds[] = $travel_tourist_embed;
						?>
						<div class="custom-embedded-audio">
							<div class="media-container">
								<?php echo $travel_tourist_embed; ?>
							</div>
						</div>
						<?php
					}
				}
			}
		?>

		<!-- .TITLE & META -->
		<header class="entry-header">
			<?php
			if ( 'post' === get_post_type() ) :

				if (is_singular()) {
					travel_tourist_breadcrumbs();
				}
				
				if ( is_singular() ) :
					$travel_tourist_single_enable_title = absint(get_theme_mod('travel_tourist_enable_single_blog_post_title', 1));
					if ($travel_tourist_single_enable_title == 1) {
						the_title( '<h1 class="entry-title">', '</h1>' );
					} ?>
				<?php
				else :
					$travel_tourist_enable_title = absint(get_theme_mod('travel_tourist_enable_blog_post_title', 1));
					if ($travel_tourist_enable_title == 1) {
						the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
					}
				endif;

				// Check if is singular
				if ( is_singular() ) : ?>
					<?php
					$travel_tourist_single_blog_meta = absint(get_theme_mod('travel_tourist_enable_single_blog_post_meta', 1));
					if($travel_tourist_single_blog_meta == 1){ ?>
					<div class="entry-meta">
						<?php
						travel_tourist_posted_on();
						travel_tourist_posted_by();
						?>
					</div><!-- .entry-meta -->
					<?php } ?>
				<?php else : 
					$travel_tourist_blog_meta = absint(get_theme_mod('travel_tourist_enable_blog_post_meta', 1));
					if($travel_tourist_blog_meta == 1){ ?>
						<div class="entry-meta">
							<?php
							travel_tourist_posted_on();
							travel_tourist_posted_by();
							?>
						</div><!-- .entry-meta -->
					<?php }
				endif;

			endif;
			?>
		</header>
		<!-- .TITLE & META -->

		
		<!-- .POST TAG -->
		<?php
		// Check if is singular
		if ( is_singular() ) : ?>
			<?php
			$travel_tourist_single_post_tags = absint(get_theme_mod('travel_tourist_enable_single_blog_post_tags', 1));
			if($travel_tourist_single_post_tags == 1){ ?>
			<?php
				$post_tags = get_the_tags();
				if ( $post_tags ) {
					echo '<div class="post-tags"><strong>' . esc_html__('Post Tags: ', 'travel-tourist') . '</strong>';
					the_tags('', ', ', '');
					echo '</div>';
				}
			?><!-- .tags -->
			<?php } ?>
		<?php else : 
			$travel_tourist_post_tags = absint(get_theme_mod('travel_tourist_enable_blog_post_tags', 1));
			if($travel_tourist_post_tags == 1){ ?>
				<?php
					$post_tags = get_the_tags();
					if ( $post_tags ) {
						echo '<div class="post-tags"><strong>' . esc_html__('Post Tags: ', 'travel-tourist') . '</strong>';
						the_tags('', ', ', '');
						echo '</div>';
					}
				?><!-- .tags -->
			<?php }
		endif;
		?>
		<!-- .POST TAG -->

		<!-- .IMAGE -->
		<?php if ( is_singular() ) : ?>
			<?php 
			$travel_tourist_blog_thumbnail = absint(get_theme_mod('travel_tourist_enable_single_post_image', 1));
			if ( $travel_tourist_blog_thumbnail == 1 ) { 
			?>
				<?php if ( has_post_thumbnail() ) { ?>
					<div class="card-media">
						<?php travel_tourist_post_thumbnail(); ?>
					</div>
				<?php } else {
					// Fallback default image
					$travel_tourist_default_post_thumbnail = get_template_directory_uri() . '/revolution/assets/images/slider1.png';
					echo '<img class="default-post-img" src="' . esc_url( $travel_tourist_default_post_thumbnail ) . '" alt="' . esc_attr( get_the_title() ) . '">';
				} ?>
			<?php } ?>
		<?php else : ?>
		<?php 
			$travel_tourist_blog_thumbnail = absint(get_theme_mod('travel_tourist_enable_blog_post_image', 1));
			if ( $travel_tourist_blog_thumbnail == 1 ) { 
			?>
				<?php if ( has_post_thumbnail() ) { ?>
					<div class="card-media">
						<?php travel_tourist_post_thumbnail(); ?>
					</div>
				<?php } else {
					// Fallback default image
					$travel_tourist_default_post_thumbnail = get_template_directory_uri() . '/revolution/assets/images/slider1.png';
					echo '<img class="default-post-img" src="' . esc_url( $travel_tourist_default_post_thumbnail ) . '" alt="' . esc_attr( get_the_title() ) . '">';
				} ?>
			<?php } ?>
		<?php endif; ?>
		<!-- .IMAGE -->

		<!-- .CONTENT & BUTTON -->
		<div class="entry-content">
			<?php
				if ( is_singular() ) :
					$travel_tourist_single_enable_excerpt = absint(get_theme_mod('travel_tourist_enable_single_blog_post_content', 1));
					if ($travel_tourist_single_enable_excerpt == 1) {
						the_content();
					} ?>
				<?php else :
					// Excerpt functionality for archive pages
					$travel_tourist_enable_excerpt = absint(get_theme_mod('travel_tourist_enable_blog_post_content', 1));
					if ($travel_tourist_enable_excerpt == 1) {
						echo "<p>".wp_trim_words(get_the_excerpt(), get_theme_mod('travel_tourist_excerpt_limit', 25))."</p>";
					}
					?>
					<?php // Check if 'Continue Reading' button should be displayed
					$travel_tourist_enable_read_more = absint(get_theme_mod('travel_tourist_enable_blog_post_button', 1));
					if ($travel_tourist_enable_read_more == 1) {
						if ( get_theme_mod( 'travel_tourist_read_more_text', __('Continue Reading....', 'travel-tourist') ) ) :
							?>
							<a href="<?php the_permalink(); ?>" class="btn read-btn text-uppercase">
								<?php echo esc_html( get_theme_mod( 'travel_tourist_read_more_text', __('Continue Reading....', 'travel-tourist') ) ); ?>
							</a>
							<?php
						endif;
					}?>
				<?php endif; ?>
			<?php
			wp_link_pages(
				array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'travel-tourist' ),
					'after'  => '</div>',
				)
			);
			?>
		</div>
		<!-- .CONTENT & BUTTON -->
	</div>
</article><!-- #post-<?php the_ID(); ?> -->