<?php
/**
 * Custom typography options for this theme
 *
 * @package Travel Tourist
 */

function travel_tourist_output_custom_font_css() {
    $travel_tourist_font_choice = get_theme_mod( 'travel_tourist_font_family', 'default' );

    if ( $travel_tourist_font_choice === 'default' ) {
        return;
    }

    $travel_tourist_font_map = array(
        'bad_script'       => '"Bad Script", cursive',
        'roboto'           => '"Roboto", sans-serif',
        'playfair_display' => '"Playfair Display", serif',
        'open_sans'        => '"Open Sans", sans-serif',
        'lobster'          => '"Lobster", cursive',
        'merriweather'     => '"Merriweather", serif',
        'oswald'           => '"Oswald", sans-serif',
        'raleway'          => '"Raleway", sans-serif',
    );

    $travel_tourist_font_family = isset( $travel_tourist_font_map[ $travel_tourist_font_choice ] ) ? $travel_tourist_font_map[ $travel_tourist_font_choice ] : $travel_tourist_font_map['pt_sans'];

    $travel_tourist_custom_css = "
        body,
        h1, h2, h3, h4, h5, h6,
        p, a, span, div,
        .site, .entry-content, .main-navigation, .widget,
        input, textarea, button, .menu, .site-title, .site-description {
            font-family: {$travel_tourist_font_family} !important;
        }
    ";

    wp_add_inline_style( 'travel-tourist-google-fonts', $travel_tourist_custom_css );
}
add_action( 'wp_enqueue_scripts', 'travel_tourist_output_custom_font_css', 20 );


function travel_tourist_sanitize_font_family( $travel_tourist_input ) {
    $travel_tourist_valid = array(
        'default', 'bad_script', 'roboto',
        'playfair_display', 'open_sans', 'lobster', 'merriweather', 'oswald', 'raleway'
    );
    return in_array( $travel_tourist_input, $travel_tourist_valid ) ? $travel_tourist_input : 'default';
}

function travel_tourist_enqueue_selected_google_font() {
    $travel_tourist_font_choice = get_theme_mod( 'travel_tourist_font_family', 'default' );

    $travel_tourist_font_links = array(
        'bad_script'       => 'https://fonts.googleapis.com/css2?family=Bad+Script&display=swap',
        'roboto'           => 'https://fonts.googleapis.com/css2?family=Roboto&display=swap',
        'playfair_display' => 'https://fonts.googleapis.com/css2?family=Playfair+Display&display=swap',
        'open_sans'        => 'https://fonts.googleapis.com/css2?family=Open+Sans&display=swap',
        'lobster'          => 'https://fonts.googleapis.com/css2?family=Lobster&display=swap',
        'merriweather'     => 'https://fonts.googleapis.com/css2?family=Merriweather&display=swap',
        'oswald'           => 'https://fonts.googleapis.com/css2?family=Oswald&display=swap',
        'raleway'          => 'https://fonts.googleapis.com/css2?family=Raleway&display=swap',
    );

    if ( isset( $travel_tourist_font_links[ $travel_tourist_font_choice ] ) ) {
        wp_enqueue_style( 'travel-tourist-dynamic-font', $travel_tourist_font_links[ $travel_tourist_font_choice ], array(), null );
    }
}
add_action( 'wp_enqueue_scripts', 'travel_tourist_enqueue_selected_google_font' );