<?php
/**
 * Travel Tourist Theme Customizer
 *
 * @package Travel Tourist
 */

function travel_tourist_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'Travel_Tourist_Customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'Travel_Tourist_Customize_partial_blogdescription',
			)
		);
	}

	/*
    * Theme Options Panel
    */
	$wp_customize->add_panel('travel_tourist_panel', array(
		'priority' => 25,
		'capability' => 'edit_theme_options',
		'title' => __('Travel Tourist Theme Options', 'travel-tourist'),
	));

	/*
	* Customizer main header section
	*/

	$wp_customize->add_setting(
		'travel_tourist_site_title_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_site_title_text',
		array(
			'label'       => __('Enable Title', 'travel-tourist'),
			'description' => __('Enable or Disable Title from the site', 'travel-tourist'),
			'section'     => 'title_tagline',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'travel_tourist_site_tagline_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_site_tagline_text',
		array(
			'label'       => __('Enable Tagline', 'travel-tourist'),
			'description' => __('Enable or Disable Tagline from the site', 'travel-tourist'),
			'section'     => 'title_tagline',
			'type'        => 'checkbox',
		)
	);

		$wp_customize->add_setting(
		'travel_tourist_logo_width',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '150',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_logo_width',
		array(
			'label'       => __('Logo Width in PX', 'travel-tourist'),
			'section'     => 'title_tagline',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 100,
	             'max' => 300,
	             'step' => 1,
	         ),
		)
	);

	/* WooCommerce custom settings */

	$wp_customize->add_section('woocommerce_custom_settings', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('WooCommerce Custom Settings', 'travel-tourist'),
		'panel'       => 'woocommerce',
	));

	$wp_customize->add_setting(
		'travel_tourist_per_columns',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_per_columns',
		array(
			'label'       => __('Product Per Single Row', 'travel-tourist'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 4,
	             'step' => 1,
	         ),
		)
	);

	$wp_customize->add_setting(
		'travel_tourist_product_per_page',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '6',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_product_per_page',
		array(
			'label'       => __('Product Per One Page', 'travel-tourist'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 12,
	             'step' => 1,
	         ),
		)
	);

	/*Related Products Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_related_product',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_enable_related_product',
		array(
			'label'       => __('Enable Related Product', 'travel-tourist'),
			'description' => __('Checked to show Related Product', 'travel-tourist'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'custom_related_products_number',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'custom_related_products_number',
		array(
			'label'       => __('Related Product Count', 'travel-tourist'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 20,
	             'step' => 1,
	         ),
		)
	);

	$wp_customize->add_setting(
		'custom_related_products_number_per_row',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'custom_related_products_number_per_row',
		array(
			'label'       => __('Related Product Per Row', 'travel-tourist'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 4,
	             'step' => 1,
	         ),
		)
	);

	/*Archive Product layout*/
	$wp_customize->add_setting('travel_tourist_archive_product_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
	));
	$wp_customize->add_control('travel_tourist_archive_product_layout',array(
        'type' => 'select',
        'label' => esc_html__('Archive Product Layout','travel-tourist'),
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','travel-tourist'),
            'layout-2' => esc_html__('Sidebar On Left','travel-tourist'),
			'layout-3' => esc_html__('Full Width Layout','travel-tourist')
        ),
	) );

	/*Single Product layout*/
	$wp_customize->add_setting('travel_tourist_single_product_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
	));
	$wp_customize->add_control('travel_tourist_single_product_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Product Layout','travel-tourist'),
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','travel-tourist'),
            'layout-2' => esc_html__('Sidebar On Left','travel-tourist'),
			'layout-3' => esc_html__('Full Width Layout','travel-tourist')
        ),
	) );

	$wp_customize->add_setting('travel_tourist_woocommerce_product_sale',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
        'default'           => 'Right',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
    ));
    $wp_customize->add_control('travel_tourist_woocommerce_product_sale',array(
        'label'       => esc_html__( 'Woocommerce Product Sale Positions','travel-tourist' ),
        'type' => 'select',
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'Right' => __('Right','travel-tourist'),
            'Left' => __('Left','travel-tourist'),
            'Center' => __('Center','travel-tourist')
        ),
    ) );

	/*Additional Options*/
	$wp_customize->add_section('travel_tourist_additional_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Additional Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_sticky_header',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => false,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_enable_sticky_header',
		array(
			'label'       => __('Enable Sticky Header', 'travel-tourist'),
			'description' => __('Checked to enable sticky header', 'travel-tourist'),
			'section'     => 'travel_tourist_additional_section',
			'type'        => 'checkbox',
		)
	);

	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_preloader',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_enable_preloader',
		array(
			'label'       => __('Enable Preloader', 'travel-tourist'),
			'description' => __('Checked to show preloader', 'travel-tourist'),
			'section'     => 'travel_tourist_additional_section',
			'type'        => 'checkbox',
		)
	);
	
	/*Breadcrumbs Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_breadcrumbs',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_enable_breadcrumbs',
		array(
			'label'       => __('Enable Breadcrumbs', 'travel-tourist'),
			'description' => __('Checked to show Breadcrumbs', 'travel-tourist'),
			'section'     => 'travel_tourist_additional_section',
			'type'        => 'checkbox',
		)
	);

	/*Post layout*/
	$wp_customize->add_setting('travel_tourist_archive_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
	));
	$wp_customize->add_control('travel_tourist_archive_layout',array(
        'type' => 'select',
        'label' => esc_html__('Posts Layout','travel-tourist'),
        'section' => 'travel_tourist_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','travel-tourist'),
            'layout-2' => esc_html__('Sidebar On Left','travel-tourist'),
			'layout-3' => esc_html__('Full Width Layout','travel-tourist')
        ),
	) );

	/*single post layout*/
	$wp_customize->add_setting('travel_tourist_post_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
	));
	$wp_customize->add_control('travel_tourist_post_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Post Layout','travel-tourist'),
        'section' => 'travel_tourist_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','travel-tourist'),
            'layout-2' => esc_html__('Sidebar On Left','travel-tourist'),
			'layout-3' => esc_html__('Full Width Layout','travel-tourist')
        ),
	) );

	/*single page layout*/
	$wp_customize->add_setting('travel_tourist_page_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
	));
	$wp_customize->add_control('travel_tourist_page_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Page Layout','travel-tourist'),
        'section' => 'travel_tourist_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','travel-tourist'),
            'layout-2' => esc_html__('Sidebar On Left','travel-tourist'),
			'layout-3' => esc_html__('Full Width Layout','travel-tourist')
        ),
	) );

	/*Archive Post Options*/
	$wp_customize->add_section('travel_tourist_blog_post_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Blog Page Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	$wp_customize->add_setting('travel_tourist_enable_blog_post_title',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_blog_post_title',array(
		'label'       => __('Enable Blog Post Title', 'travel-tourist'),
		'description' => __('Checked To Show Blog Post Title', 'travel-tourist'),
		'section'     => 'travel_tourist_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_blog_post_meta',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_blog_post_meta',array(
		'label'       => __('Enable Blog Post Meta', 'travel-tourist'),
		'description' => __('Checked To Show Blog Post Meta Feilds', 'travel-tourist'),
		'section'     => 'travel_tourist_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_blog_post_tags',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_blog_post_tags',array(
		'label'       => __('Enable Blog Post Tags', 'travel-tourist'),
		'description' => __('Checked To Show Blog Post Tags', 'travel-tourist'),
		'section'     => 'travel_tourist_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_blog_post_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_blog_post_image',array(
		'label'       => __('Enable Blog Post Image', 'travel-tourist'),
		'description' => __('Checked To Show Blog Post Image', 'travel-tourist'),
		'section'     => 'travel_tourist_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_blog_post_content',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_blog_post_content',array(
		'label'       => __('Enable Blog Post Content', 'travel-tourist'),
		'description' => __('Checked To Show Blog Post Content', 'travel-tourist'),
		'section'     => 'travel_tourist_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_blog_post_button',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_blog_post_button',array(
		'label'       => __('Enable Blog Post Read More Button', 'travel-tourist'),
		'description' => __('Checked To Show Blog Post Read More Button', 'travel-tourist'),
		'section'     => 'travel_tourist_blog_post_section',
		'type'        => 'checkbox',
	));

	/*Blog post Content layout*/
	$wp_customize->add_setting('travel_tourist_blog_Post_content_layout',array(
        'default' => 'Left',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
	));
	$wp_customize->add_control('travel_tourist_blog_Post_content_layout',array(
        'type' => 'select',
        'label' => esc_html__('Blog Post Content Layout','travel-tourist'),
        'section' => 'travel_tourist_blog_post_section',
        'choices' => array(
            'Left' => esc_html__('Left','travel-tourist'),
            'Center' => esc_html__('Center','travel-tourist'),
            'Right' => esc_html__('Right','travel-tourist')
        ),
	) );

	/*Excerpt*/
    $wp_customize->add_setting(
		'travel_tourist_excerpt_limit',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '25',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_excerpt_limit',
		array(
			'label'       => __('Excerpt Limit', 'travel-tourist'),
			'section'     => 'travel_tourist_blog_post_section',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 2,
	             'max' => 50,
	             'step' => 2,
	         ),
		)
	);

	/*Archive Button Text*/
	$wp_customize->add_setting(
		'travel_tourist_read_more_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 'Continue Reading....',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_read_more_text',
		array(
			'label'       => __('Edit Button Text ', 'travel-tourist'),
			'section'     => 'travel_tourist_blog_post_section',
			'type'        => 'text',
		)
	);

	/*Single Post Options*/
	$wp_customize->add_section('travel_tourist_single_post_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Single Post Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	$wp_customize->add_setting('travel_tourist_enable_single_blog_post_title',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_single_blog_post_title',array(
		'label'       => __('Enable Single Post Title', 'travel-tourist'),
		'description' => __('Checked To Show Single Blog Post Title', 'travel-tourist'),
		'section'     => 'travel_tourist_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_single_blog_post_meta',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_single_blog_post_meta',array(
		'label'       => __('Enable Single Post Meta', 'travel-tourist'),
		'description' => __('Checked To Show Single Blog Post Meta Feilds', 'travel-tourist'),
		'section'     => 'travel_tourist_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_single_blog_post_tags',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_single_blog_post_tags',array(
		'label'       => __('Enable Single Post Tags', 'travel-tourist'),
		'description' => __('Checked To Show Single Blog Post Tags', 'travel-tourist'),
		'section'     => 'travel_tourist_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_single_post_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_single_post_image',array(
		'label'       => __('Enable Single Post Image', 'travel-tourist'),
		'description' => __('Checked To Show Single Post Image', 'travel-tourist'),
		'section'     => 'travel_tourist_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('travel_tourist_enable_single_blog_post_content',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
	));
	$wp_customize->add_control('travel_tourist_enable_single_blog_post_content',array(
		'label'       => __('Enable Single Post Content', 'travel-tourist'),
		'description' => __('Checked To Show Single Blog Post Content', 'travel-tourist'),
		'section'     => 'travel_tourist_single_post_section',
		'type'        => 'checkbox',
	));

	/*Related Post Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_related_post',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_enable_related_post',
		array(
			'label'       => __('Enable Related Post', 'travel-tourist'),
			'description' => __('Checked to show Related Post', 'travel-tourist'),
			'section'     => 'travel_tourist_single_post_section',
			'type'        => 'checkbox',
		)
	);

	/*Related post Edit Text*/
	$wp_customize->add_setting(
		'travel_tourist_related_post_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 'Related Post',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_related_post_text',
		array(
			'label'       => __('Edit Related Post Text ', 'travel-tourist'),
			'section'     => 'travel_tourist_single_post_section',
			'type'        => 'text',
		)
	);	

	/*Related Post Per Page*/
	$wp_customize->add_setting(
		'travel_tourist_related_post_count',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_related_post_count',
		array(
			'label'       => __('Related Post Count', 'travel-tourist'),
			'section'     => 'travel_tourist_single_post_section',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 9,
	             'step' => 1,
	         ),
		)
	);

		/*
	* Customizer Global COlor
	*/

	/*Global Color Options*/
	$wp_customize->add_section('travel_tourist_global_color_section', array(
		'priority'       => 1,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Global Color Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	$wp_customize->add_setting( 'travel_tourist_primary_color',
		array(
		'default'           => '#F58025',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
		)
	);
	$wp_customize->add_control( 
		new WP_Customize_Color_Control( 
		$wp_customize, 
		'travel_tourist_primary_color',
		array(
			'label'      => esc_html__( 'Primary Color', 'travel-tourist' ),
			'section'    => 'travel_tourist_global_color_section',
			'settings'   => 'travel_tourist_primary_color',
		) ) 
	);

	/*Typography Options*/
	$wp_customize->add_section( 'travel_tourist_typography_section', array(
		'panel'       => 'travel_tourist_panel',
        'title'    => __( 'Typography Options', 'travel-tourist' ),
        'priority' => 2,
    ) );

    $wp_customize->add_setting( 'travel_tourist_font_family', array(
		'default'           => 'default',
		'sanitize_callback' => 'travel_tourist_sanitize_font_family',
	) );
	
	$wp_customize->add_control( 'travel_tourist_font_family', array(
		'label'    => __( 'Global Font Family', 'travel-tourist' ),
		'section'  => 'travel_tourist_typography_section',
		'type'     => 'select',
		'choices'  => array(
			'default'          => __( 'Default (Theme Font)', 'travel-tourist' ),
			'bad_script'       => 'Bad Script',
			'roboto'           => 'Roboto',
			'playfair_display' => 'Playfair Display',
			'open_sans'        => 'Open Sans',
			'lobster'          => 'Lobster',
			'merriweather'     => 'Merriweather',
			'oswald'           => 'Oswald',
			'raleway'          => 'Raleway',
		),
	) );

	/*
	* Customizer main header section
	*/

	/*Main Header Options*/
	$wp_customize->add_section('travel_tourist_header_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Main Header Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	$wp_customize->add_setting(
		'travel_tourist_header_search',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'travel_tourist_header_search',
		array(
			'label'       => __('Enable Disable Search', 'travel-tourist'),
			'description' => __('Enable or Disable header Search', 'travel-tourist'),
			'section'     => 'travel_tourist_header_section',
			'type'        => 'checkbox',
		)
	);

	/*
	* Customizer main slider section
	*/
	/*Main Slider Options*/
	$wp_customize->add_section('travel_tourist_slider_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Main Slider Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_slider',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_enable_slider',
		array(
			'label'       => __('Enable Main Slider', 'travel-tourist'),
			'description' => __('Checked to show the main slider', 'travel-tourist'),
			'section'     => 'travel_tourist_slider_section',
			'type'        => 'checkbox',
		)
	);

	for ($travel_tourist_i=1; $travel_tourist_i <= 3; $travel_tourist_i++) { 

		/*Main Slider Image*/
		$wp_customize->add_setting(
			'travel_tourist_slider_image'.$travel_tourist_i,
			array(
				'capability'    => 'edit_theme_options',
		        'default'       => '',
		        'transport'     => 'postMessage',
		        'sanitize_callback' => 'esc_url_raw',
	    	)
	    );

		$wp_customize->add_control( 
			new WP_Customize_Image_Control( $wp_customize, 
				'travel_tourist_slider_image'.$travel_tourist_i, 
				array(
			        'label' => __('Edit Slider Image ', 'travel-tourist') .$travel_tourist_i,
			        'description' => __('Edit the slider image.', 'travel-tourist'),
			        'section' => 'travel_tourist_slider_section',
				)
			)
		);

		/*Main Slider Heading*/
		$wp_customize->add_setting(
			'travel_tourist_slider_top_text'.$travel_tourist_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'travel_tourist_slider_top_text'.$travel_tourist_i,
			array(
				'label'       => __('Edit Slider Top Text ', 'travel-tourist') .$travel_tourist_i,
				'description' => __('Edit the slider Top text.', 'travel-tourist'),
				'section'     => 'travel_tourist_slider_section',
				'type'        => 'text',
			)
		);

		/*Main Slider Heading*/
		$wp_customize->add_setting(
			'travel_tourist_slider_heading'.$travel_tourist_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'travel_tourist_slider_heading'.$travel_tourist_i,
			array(
				'label'       => __('Edit Heading Text ', 'travel-tourist') .$travel_tourist_i,
				'description' => __('Edit the slider heading text.', 'travel-tourist'),
				'section'     => 'travel_tourist_slider_section',
				'type'        => 'text',
			)
		);

		/*Main Slider Content*/
		$wp_customize->add_setting(
			'travel_tourist_slider_text'.$travel_tourist_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'travel_tourist_slider_text'.$travel_tourist_i,
			array(
				'label'       => __('Edit Content Text ', 'travel-tourist') .$travel_tourist_i,
				'description' => __('Edit the slider content text.', 'travel-tourist'),
				'section'     => 'travel_tourist_slider_section',
				'type'        => 'text',
			)
		);

	}


	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_slider_form_hide_show',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'travel_tourist_slider_form_hide_show',
		array(
			'label'       => __('Enable Searchform', 'travel-tourist'),
			'description' => __('Checked to show Searchform', 'travel-tourist'),
			'section'     => 'travel_tourist_slider_section',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting('travel_tourist_slider_total_user',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('travel_tourist_slider_total_user',array(
		'label'	=> __('Add Total Number of Happy Customer','travel-tourist'),
		'section'	=> 'travel_tourist_slider_section',
		'type'		=> 'text'
	));

	for ($travel_tourist_i=1; $travel_tourist_i <= 4; $travel_tourist_i++) { 

		$wp_customize->add_setting('travel_tourist_banner_image'. $travel_tourist_i, array(
		    'default'           => '',
		    'sanitize_callback' => 'esc_url_raw',
		));
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'travel_tourist_banner_image' . $travel_tourist_i, array(
		    'label'   => __('Select Customer Image ', 'travel-tourist') . $travel_tourist_i,
		    'section' => 'travel_tourist_slider_section',
		)));
	}

	/*Main Header Button Link*/
	$wp_customize->add_setting(
		'travel_tourist_more_button_link',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control(
		'travel_tourist_more_button_link',
		array(
			'label'       => __('Add View More Images Link ', 'travel-tourist'),
			'section'     => 'travel_tourist_slider_section',
			'type'        => 'url',
		)
	);
	
	/*
	* Customizer Blog section
	*/
	/*Blog Options*/
	$wp_customize->add_section('travel_tourist_events_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Our Tour Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	/*Blog Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_event',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'travel_tourist_enable_event',
		array(
			'label'       => __('Enable Our Tour Section', 'travel-tourist'),
			'description' => __('Checked to show the Tour Section', 'travel-tourist'),
			'section'     => 'travel_tourist_events_section',
			'type'        => 'checkbox',
		)
	);

	/*Blog Heading*/
	$wp_customize->add_setting(
		'travel_tourist_small_title',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'travel_tourist_small_title',
		array(
			'label'       => __('Add Section Small Title', 'travel-tourist'),
			'description' => __('Add Section Small Title', 'travel-tourist'),
			'section'     => 'travel_tourist_events_section',
			'type'        => 'text',
		)
	);

	/*Blog Heading*/
	$wp_customize->add_setting(
		'travel_tourist_event_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'travel_tourist_event_text',
		array(
			'label'       => __('Add Section Heading', 'travel-tourist'),
			'description' => __('Add Section Heading', 'travel-tourist'),
			'section'     => 'travel_tourist_events_section',
			'type'        => 'text',
		)
	);

	/*
	* Customizer Footer Section
	*/
	/*Footer Options*/
	$wp_customize->add_section('travel_tourist_footer_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Footer Options', 'travel-tourist'),
		'panel'       => 'travel_tourist_panel',
	));

	/*Footer Enable Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_footer',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'travel_tourist_enable_footer',
		array(
			'label'       => __('Enable Footer', 'travel-tourist'),
			'description' => __('Checked to show Footer', 'travel-tourist'),
			'section'     => 'travel_tourist_footer_section',
			'type'        => 'checkbox',
		)
	);

	/*Footer bg image Option*/
	$wp_customize->add_setting('travel_tourist_footer_bg_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'travel_tourist_footer_bg_image',array(
        'label' => __('Footer Background Image','travel-tourist'),
        'section' => 'travel_tourist_footer_section',
        'priority' => 1,
    )));

	/*Footer Social Menu Option*/
	$wp_customize->add_setting(
		'travel_tourist_footer_social_menu',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_footer_social_menu',
		array(
			'label'       => __('Enable Footer Social Menu', 'travel-tourist'),
			'description' => __('Checked to show the footer social menu. Go to Dashboard >> Appearance >> Menus >> Create New Menu >> Add Custom Link >> Add Social Menu >> Checked Social Menu >> Save Menu.', 'travel-tourist'),
			'section'     => 'travel_tourist_footer_section',
			'type'        => 'checkbox',
		)
	);	

	/*Go To Top Option*/
	$wp_customize->add_setting(
		'travel_tourist_enable_go_to_top_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'travel_tourist_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_enable_go_to_top_option',
		array(
			'label'       => __('Enable Go To Top', 'travel-tourist'),
			'description' => __('Checked to enable Go To Top option.', 'travel-tourist'),
			'section'     => 'travel_tourist_footer_section',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting('travel_tourist_go_to_top_position',array(
        'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 'Right',
        'sanitize_callback' => 'travel_tourist_sanitize_choices'
    ));
    $wp_customize->add_control('travel_tourist_go_to_top_position',array(
        'type' => 'select',
        'section' => 'travel_tourist_footer_section',
        'label' => esc_html__('Go To Top Positions','travel-tourist'),
        'choices' => array(
            'Right' => __('Right','travel-tourist'),
            'Left' => __('Left','travel-tourist'),
            'Center' => __('Center','travel-tourist')
        ),
    ) );

	/*Footer Copyright Text Enable*/
	$wp_customize->add_setting(
		'travel_tourist_copyright_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'travel_tourist_copyright_option',
		array(
			'label'       => __('Edit Copyright Text', 'travel-tourist'),
			'description' => __('Edit the Footer Copyright Section.', 'travel-tourist'),
			'section'     => 'travel_tourist_footer_section',
			'type'        => 'text',
		)
	);
}
add_action( 'customize_register', 'travel_tourist_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function Travel_Tourist_Customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function Travel_Tourist_Customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function Travel_Tourist_Customize_preview_js() {
	wp_enqueue_script( 'travel-tourist-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), TRAVEL_TOURIST_VERSION, true );
}
add_action( 'customize_preview_init', 'Travel_Tourist_Customize_preview_js' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Travel_Tourist_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $travel_tourist_instance = null;

		if ( is_null( $travel_tourist_instance ) ) {
			$travel_tourist_instance = new self;
			$travel_tourist_instance->setup_actions();
		}

		return $travel_tourist_instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $travel_tourist_manager
	 * @return void
	*/
	public function sections( $travel_tourist_manager ) {
		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/revolution/inc/section-pro.php' );

		// Register custom section types.
		$travel_tourist_manager->register_section_type( 'Travel_Tourist_Customize_Section_Pro' );

		// Register sections.
		$travel_tourist_manager->add_section( new Travel_Tourist_Customize_Section_Pro( $travel_tourist_manager,'travel_tourist_go_pro', array(
			'priority'   => 1,
			'title'    => esc_html__( 'Travel Tourist Pro', 'travel-tourist' ),
			'pro_text' => esc_html__( 'Buy Pro', 'travel-tourist' ),
			'pro_url'    => esc_url( TRAVEL_TOURIST_BUY_NOW ),
		) )	);

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'travel-tourist-customize-controls', trailingslashit( get_template_directory_uri() ) . '/revolution/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'travel-tourist-customize-controls', trailingslashit( get_template_directory_uri() ) . '/revolution/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Travel_Tourist_Customize::get_instance();