<?php
/**
 * Template Name: Home Page
 */
get_header();
?>

<main id="primary">
  <?php 
    $travel_tourist_main_slider_wrap = absint(get_theme_mod('travel_tourist_enable_slider', 0));

    if ($travel_tourist_main_slider_wrap == 1): 
  ?>
    <section id="main-slider-wrap" style="background-color: #f6f7f6;">
        <div class="slider-main">
            <div class="owl-carousel">
                <?php for ($travel_tourist_main_i = 1; $travel_tourist_main_i <= 3; $travel_tourist_main_i++): ?>
                    <?php 
                    $travel_tourist_slider_image = get_theme_mod('travel_tourist_slider_image' . $travel_tourist_main_i);
                    if ($travel_tourist_slider_image): 
                    ?>
                      <div class="main-slider-inner-box">
                          <div class="container-fluid">
                              <div class="flex-row">
                                  <div class="slider-left">
                                      <div class="main-slider-content-box">
                                          <?php if ($travel_tourist_top_text = get_theme_mod('travel_tourist_slider_top_text' . $travel_tourist_main_i)): ?>
                                              <p class="slider-top"><?php echo esc_html($travel_tourist_top_text); ?></p>
                                          <?php endif; ?>
                                          <?php if ($travel_tourist_heading = get_theme_mod('travel_tourist_slider_heading' . $travel_tourist_main_i)): ?>
                                              <h1><?php echo esc_html($travel_tourist_heading); ?></h1>
                                          <?php endif; ?>
                                          <?php if ($travel_tourist_text = get_theme_mod('travel_tourist_slider_text' . $travel_tourist_main_i)): ?>
                                              <p class="slider-para"><?php echo wp_kses_post($travel_tourist_text); ?></p>
                                          <?php endif; ?>
                                      </div>
                                  </div>
                                  <div class="slider-right">
                                      <img src="<?php echo esc_url($travel_tourist_slider_image); ?>" alt="<?php echo esc_attr($travel_tourist_heading); ?>">
                                  </div>
                              </div>
                          </div>
                      </div>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
        </div>
        <?php if ( get_theme_mod( 'travel_tourist_slider_form_hide_show', 0 ) ) : ?>
          <div class="travel-search-section">
            <div class="wrapper">
              <div class="wp-travel-filter">
                <?php 
                if ( class_exists( 'WP_Travel' ) ) {
                    travel_tourist_wptravel_search_form(); 
                } else {
                    echo get_search_form();
                }
                ?>
              </div>
            </div>     
          </div>
      <?php endif; ?>
      <?php  
        $travel_tourist_total_user = get_theme_mod('travel_tourist_slider_total_user');
        $travel_tourist_has_image  = false;
        // Check if any of the 5 images exist
        for ( $travel_tourist_i = 1; $travel_tourist_i <= 4; $travel_tourist_i++ ) {
            if ( get_theme_mod( 'travel_tourist_banner_image' . $travel_tourist_i ) ) {
                $travel_tourist_has_image = true;
                break;
            }
        }
        if ( $travel_tourist_total_user || $travel_tourist_has_image ) : ?>
            <div class="rating-col">
                <?php if ( $travel_tourist_total_user ) : ?>
                    <p class="slidetop-text">
                        <?php echo esc_html( $travel_tourist_total_user ); ?>
                    </p>
                <?php endif; ?>

                <div class="happy-customer">
                    <?php esc_html_e( 'Happy Customer', 'travel-tourist' ); ?>
                </div>

                <div class="rating-box">
                    <?php for ( $travel_tourist_i = 1; $travel_tourist_i <= 4; $travel_tourist_i++ ) : 
                        $travel_tourist_img = get_theme_mod( 'travel_tourist_banner_image' . $travel_tourist_i );
                        if ( $travel_tourist_img ) : ?>
                            <img src="<?php echo esc_url( $travel_tourist_img ); ?>" alt="customer" />
                        <?php endif;
                    endfor; ?>

                    <div class="more">
                        <?php 
                        $travel_tourist_more_button_link = get_theme_mod( 'travel_tourist_more_button_link' );
                        if ( ! empty( $travel_tourist_more_button_link ) ) : ?>
                            <a class="customer-plus" href="<?php echo esc_url( $travel_tourist_more_button_link ); ?>">
                                <?php echo esc_html__( '+', 'travel-tourist' ); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
      <?php endif; ?>
    </section>
  <?php endif; ?>

  <?php 
  $travel_tourist_rental_enable = absint( get_theme_mod('travel_tourist_enable_event', 0) ); 
  if ( $travel_tourist_rental_enable === 1 ) : 
  ?>
    <section id="category-section">
      <div class="container">
        <div class="main-top-text">
          <div class="heading-expert-wrap">
            <?php if ( $travel_tourist_small = get_theme_mod('travel_tourist_small_title') ): ?>
              <p class="post-title"><?php echo esc_html( $travel_tourist_small ); ?></p>
            <?php endif; ?>
            <?php if ( $travel_tourist_heading = get_theme_mod('travel_tourist_event_text') ): ?>
              <h2><?php echo esc_html( $travel_tourist_heading ); ?></h2>
            <?php endif; ?>
          </div>
          <?php 
          // Get WP Travel trip categories
          $travel_tourist_terms = get_terms([
            'taxonomy'   => 'itinerary_types', // WP Travel taxonomy for trip categories
            'hide_empty' => true
          ]);
          // Build tabs
          $travel_tourist_tabs = [
            'all' => [
              'label'  => esc_html__('All', 'travel-tourist'),
              'filter' => '*'
            ]
          ];
          if ( ! empty( $travel_tourist_terms ) && ! is_wp_error($travel_tourist_terms) ) {
            foreach ( $travel_tourist_terms as $term ) {
              $travel_tourist_tabs[ $term->slug ] = [
                'label'  => $term->name,
                'filter' => '.trip_cat_' . $term->term_id
              ];
            }
          }
          ?>
          <div class="property-tabs">
            <ul class="property-tabs__list" role="tablist">
              <?php foreach ( $travel_tourist_tabs as $slug => $conf ) : ?>
                <li class="property-tabs__item" 
                    role="tab" 
                    tabindex="0" 
                    data-filter="<?php echo esc_attr( $conf['filter'] ); ?>">
                  <?php echo esc_html( $conf['label'] ); ?>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        </div>
        <div id="property-list">
          <div class="category-listing-row">
            <?php 
            $travel_tourist_args = [
              'post_type'           => 'itineraries', // WP Travel trips
              'posts_per_page'      => 100,
              'ignore_sticky_posts' => true,
              'orderby'             => 'date',
              'order'               => 'DESC',
              'post_status'         => 'publish'
            ];

            $travel_tourist_loop = new WP_Query( $travel_tourist_args );
            if ( $travel_tourist_loop->have_posts() ) :
              while ( $travel_tourist_loop->have_posts() ) : $travel_tourist_loop->the_post();
                $travel_tourist_id = get_the_ID();

                $travel_tourist_trip_terms = get_the_terms( $travel_tourist_id, 'itinerary_types' );
                $travel_tourist_classes = '';
                $travel_tourist_names   = [];

                if ( $travel_tourist_trip_terms && ! is_wp_error( $travel_tourist_trip_terms ) ) {
                  foreach ( $travel_tourist_trip_terms as $tt ) {
                    $travel_tourist_classes .= ' trip_cat_' . $tt->term_id;
                    $travel_tourist_names[] = $tt->name;
                  }
                }

            ?>
            <div class="property-item<?php echo esc_attr( $travel_tourist_classes ); ?>">
              <div class="property-content">
                <div class="img-box">
                  <?php if ( has_post_thumbnail() ) : ?>
                    <?php the_post_thumbnail('medium'); ?>
                  <?php else : ?>
                    <div class="img-blank"></div>
                  <?php endif; ?>
                    <!-- Price -->
                    <div class="price-meta">
                      <?php 
                      if ( class_exists('WP_Travel_Helpers_Pricings') ) {
                          $travel_tourist_trip_price = WP_Travel_Helpers_Pricings::get_price( array( 'trip_id' => get_the_ID() ) );
                          echo '<span><span class="trip-price">' . travel_tourist_wptravel_get_formated_price_currency( $travel_tourist_trip_price ) . '</span></span>';
                      }
                      ?>
                    </div>
                </div>
                <div class="post-main-detail">
                    <h3 class="property-title">
                       <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h3>
                    <div class="property-location">
                      <?php 
                      $travel_tourist_terms = get_the_terms( get_the_ID(), 'travel_locations' );
                      if ( is_array( $travel_tourist_terms ) && count( $travel_tourist_terms ) > 0 ) {
                          foreach ( $travel_tourist_terms as $term ) {
                              echo '<a href="' . esc_url( get_term_link( $term->term_id ) ) . '">
                                      <i class="fas fa-map-marker-alt"></i> ' . esc_html( $term->name ) . 
                                   '</a> ';
                          }
                      }
                      ?>
                  </div>
                  <div class="last-admin">
                    <div class="wp-travel-trip-time trip-fixed-departure">
                        <?php 
                        if ( function_exists('travel_tourist_wptravel_get_trip_duration') ) {
                            travel_tourist_wptravel_get_trip_duration( get_the_ID() );
                        }
                        ?>
                    </div>
                    <div class="post-author">
                        <?php the_author(); ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <?php 
              endwhile; 
              wp_reset_postdata(); 
            endif; 
            ?>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
</main>
<?php
get_footer();
?>