<?php
/**
 * The header for our theme
 *
 * @package Travel Tourist
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'travel-tourist' ); ?></a>
    <?php
    $travel_tourist_preloader_wrap = absint(get_theme_mod('travel_tourist_enable_preloader', 0));
    if ($travel_tourist_preloader_wrap === 1): ?>
        <div id="loader">
            <div class="loader-container">
                <div id="preloader" class="loader-2">
                    <div class="dot"></div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <header id="masthead" class="site-header">
        <?php $travel_tourist_has_header_image = has_header_image();

        if ($travel_tourist_has_header_image) {
            $travel_tourist_header_image_url = esc_url(get_header_image());
        } else {
            $travel_tourist_header_image_url = '';
        }
        ?>
        <div class="header-menu-box <?php echo esc_attr( get_theme_mod( 'travel_tourist_enable_sticky_header', false ) ? 'sticky-header' : '' ); ?>" style="background-image: url('<?php echo $travel_tourist_header_image_url; ?>');">
            <div class="container">
                <div class="flex-row">
                    <div class="nav-menu-header-left">
                        <div class="site-branding">
                            <?php
                            the_custom_logo();
                            if (is_front_page() && is_home()):
                                if (get_theme_mod('travel_tourist_site_title_text', true)): ?>
                                    <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <?php endif;
                            else:
                                if (get_theme_mod('travel_tourist_site_title_text', true)): ?>
                                    <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></p>
                                <?php endif;
                            endif;

                            $travel_tourist_description = get_bloginfo('description', 'display');
                            if ($travel_tourist_description || is_customize_preview()):
                                if (get_theme_mod('travel_tourist_site_tagline_text', false)): ?>
                                    <p class="site-description"><?php echo esc_html($travel_tourist_description); ?></p>
                                <?php endif;
                            endif; ?>
                        </div>
                    </div>
                    <div class="nav-menu-header-center">
                        <nav id="site-navigation" class="main-navigation">
                            <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                <span class="screen-reader-text"><?php esc_html_e('Primary Menu', 'travel-tourist'); ?></span>
                                <i class="fas fa-bars"></i>
                            </button>
                            <?php
                            wp_nav_menu(array(
                                'theme_location' => 'menu-1',
                                'menu_id'        => 'primary-menu',
                            ));
                            ?>
                        </nav>
                    </div>
                    <div class="nav-menu-header-right">
                        <div class="header-button">
                            <?php if ( get_theme_mod( 'travel_tourist_header_search', true ) == 1 ) : ?>
                                <span class="search-bar">
                                    <button type="button" class="open-search"><span><?php echo esc_html__( 'Search Here', 'travel-tourist' ); ?></span></button>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="search-outer">
                    <div class="inner_searchbox">
                        <?php get_search_form(); ?>
                    </div>
                    <button type="button" class="search-close"><i class="fas fa-window-close"></i></button>
                </div>
            </div>
        </div>
    </header>
</div>