<?php
/**
 * Travel Tourist functions and definitions
 *
 * @package Travel Tourist
 */

if ( ! defined( 'TRAVEL_TOURIST_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'TRAVEL_TOURIST_VERSION', '1.0.0' );
}

function travel_tourist_setup() {

	load_theme_textdomain( 'travel-tourist', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( "align-wide" );
	add_theme_support( "responsive-embeds" );

	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'travel-tourist' ),
			'social-menu' => esc_html__('Social Menu', 'travel-tourist'),
		)
	);

	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	add_theme_support(
		'custom-background',
		apply_filters(
			'travel_tourist_custom_background_args',
			array(
				'default-color' => '#fafafa',
				'default-image' => '',
			)
		)
	);

	add_theme_support( 'customize-selective-refresh-widgets' );

	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
    
    add_theme_support( 'post-formats', array(
        'image',
        'video',
        'gallery',
        'audio', 
    ));
	
}
add_action( 'after_setup_theme', 'travel_tourist_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $travel_tourist_content_width
 */
function travel_tourist_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'travel_tourist_content_width', 640 );
}
add_action( 'after_setup_theme', 'travel_tourist_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function travel_tourist_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'travel-tourist' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'travel-tourist' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'travel-tourist' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here.', 'travel-tourist' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'travel-tourist' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here.', 'travel-tourist' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'travel-tourist' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here.', 'travel-tourist' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'travel_tourist_widgets_init' );


function travel_tourist_social_menu()
    {
        if (has_nav_menu('social-menu')) :
            wp_nav_menu(array(
                'theme_location' => 'social-menu',
                'container' => 'ul',
                'menu_class' => 'social-menu menu',
                'menu_id'  => 'menu-social',
            ));
        endif;
    }

// Font enqueue function
function travel_tourist_scripts() {
    wp_enqueue_style(
	    'travel-tourist-google-fonts',
	    'https://fonts.googleapis.com/css2?family=Noto+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Kalam:wght@300;400;700&display=swap',
	    array(),
	    null
	);

    // Font Awesome CSS
    wp_enqueue_style('font-awesome-5', get_template_directory_uri() . '/revolution/assets/vendors/font-awesome-5/css/all.min.css', array(), '5.15.3');

    // Owl Carousel CSS
    wp_enqueue_style('owl-carousel-style', get_template_directory_uri() . '/revolution/assets/css/owl.carousel.css', array(), wp_get_theme()->get('Version'));

    // Main stylesheet
    wp_enqueue_style('travel-tourist-style', get_stylesheet_uri(), array(), wp_get_theme()->get('Version'));

    // Add custom inline styles safely
    $custom_style_path = get_parent_theme_file_path('/custom-style.php');
    if (file_exists($custom_style_path)) {
        require $custom_style_path;
        if (!empty($travel_tourist_custom_css)) {
            wp_add_inline_style('travel-tourist-style', $travel_tourist_custom_css);
        }
    }

    // RTL styles if needed
    wp_style_add_data('travel-tourist-style', 'rtl', 'replace');

    // Navigation script
    wp_enqueue_script('travel-tourist-navigation', get_template_directory_uri() . '/js/navigation.js', array(), wp_get_theme()->get('Version'), true);

    // Owl Carousel script
    wp_enqueue_script('owl-carousel-jquery', get_template_directory_uri() . '/revolution/assets/js/owl.carousel.js', array('jquery'), wp_get_theme()->get('Version'), true);

    // Custom script
    wp_enqueue_script('travel-tourist-custom-js', get_template_directory_uri() . '/revolution/assets/js/custom.js', array('jquery'), wp_get_theme()->get('Version'), true);

    // Comments reply script
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'travel_tourist_scripts');

// related post
if (!function_exists('travel_tourist_related_post')) :
    /**
     * Display related posts from same category
     *
     */

    function travel_tourist_related_post($post_id){        
        $travel_tourist_categories = get_the_category($post_id);
        if ($travel_tourist_categories) {
            $travel_tourist_category_ids = array();
            $travel_tourist_category = get_category($travel_tourist_category_ids);
            $travel_tourist_categories = get_the_category($post_id);
            foreach ($travel_tourist_categories as $travel_tourist_category) {
                $travel_tourist_category_ids[] = $travel_tourist_category->term_id;
            }
            $count = $travel_tourist_category->category_count;
            if ($count > 1) { ?>

         	<?php
		$travel_tourist_related_post_wrap = absint(get_theme_mod('travel_tourist_enable_related_post', 1));
		if($travel_tourist_related_post_wrap == 1){ ?>
                <div class="related-post">
                    
                    <h2 class="post-title"><?php esc_html_e(get_theme_mod('travel_tourist_related_post_text', __('Related Post', 'travel-tourist'))); ?></h2>
                    <?php
                    $travel_tourist_cat_post_args = array(
                        'category__in' => $travel_tourist_category_ids,
                        'post__not_in' => array($post_id),
                        'post_type' => 'post',
                        'posts_per_page' =>  get_theme_mod( 'travel_tourist_related_post_count', '3' ),
                        'post_status' => 'publish',
						'orderby'           => 'rand',
                        'ignore_sticky_posts' => true
                    );
                    $travel_tourist_featured_query = new WP_Query($travel_tourist_cat_post_args);
                    ?>
                    <div class="rel-post-wrap">
                        <?php
                        if ($travel_tourist_featured_query->have_posts()) :

                        while ($travel_tourist_featured_query->have_posts()) : $travel_tourist_featured_query->the_post();
                            ?>

                            <div class="card-item rel-card-item">
								<div class="card-content">
                                    <?php if ( has_post_thumbnail() ) { ?>
                                        <div class="card-media">
                                            <?php travel_tourist_post_thumbnail(); ?>
                                        </div>
                                    <?php } else {
                                        // Fallback default image
                                        $travel_tourist_default_post_thumbnail = get_template_directory_uri() . '/revolution/assets/images/slider1.png';
                                        echo '<img class="default-post-img" src="' . esc_url( $travel_tourist_default_post_thumbnail ) . '" alt="' . esc_attr( get_the_title() ) . '">';
                                    } ?>
									<div class="entry-title">
										<h3>
											<a href="<?php the_permalink() ?>">
												<?php the_title(); ?>
											</a>
										</h3>
									</div>
									<div class="entry-meta">
                                        <?php
                                        travel_tourist_posted_on();
                                        travel_tourist_posted_by();
                                        ?>
                                    </div>
								</div>
							</div>
                        <?php
                        endwhile;
                        ?>
                <?php
                endif;
                wp_reset_postdata();
                ?>
                </div>
                <?php } ?>
                <?php
            }
        }
    }
endif;
add_action('travel_tourist_related_posts', 'travel_tourist_related_post', 10, 1);

function travel_tourist_sanitize_choices( $travel_tourist_input, $travel_tourist_setting ) {
    global $wp_customize; 
    $travel_tourist_control = $wp_customize->get_control( $travel_tourist_setting->id ); 
    if ( array_key_exists( $travel_tourist_input, $travel_tourist_control->choices ) ) {
        return $travel_tourist_input;
    } else {
        return $travel_tourist_setting->default;
    }
}

/**
 * Checkbox sanitization callback example.
 *
 * Sanitization callback for 'checkbox' type controls. This callback sanitizes `$travel_tourist_checked`
 * as a boolean value, either TRUE or FALSE.
 */
function travel_tourist_sanitize_checkbox($travel_tourist_checked)
{
    // Boolean check.
    return ((isset($travel_tourist_checked) && true == $travel_tourist_checked) ? true : false);
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/revolution/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/revolution/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/revolution/inc/template-functions.php';

/**
 * TGM
 */
require get_template_directory() . '/tgm/tgm.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/revolution/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
    require get_template_directory() . '/revolution/inc/jetpack.php';
}

/**
 * Breadcrumb File.
 */
require get_template_directory() . '/revolution/inc/breadcrumbs.php';

/**
 * Custom typography options for this theme.
 */
require get_template_directory() . '/revolution/inc/typography-options.php';

//////////////////////////////////////////////   Function for Translation Error   //////////////////////////////////////////////////////
function travel_tourist_enqueue_assets() {
    
    define('TRAVEL_TOURIST_BUY_NOW',__('https://www.revolutionwp.com/products/tourist-wordpress-theme','travel-tourist'));
    

}
add_action( 'after_setup_theme', 'travel_tourist_enqueue_assets' );

if ( class_exists( 'WP_Travel' ) ) {
    /**
    * OCDI plugin demo importer compatibility.
    */
    require get_template_directory() . '/wp-travel/wp-travel.php';
}

function travel_tourist_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'travel_tourist_remove_customize_register', 11 );

/************************************************************************************/
// //////////////////////////////////////////////

/**
 * WooCommerce custom filters
 */
add_filter('loop_shop_columns', 'travel_tourist_loop_columns');

if (!function_exists('travel_tourist_loop_columns')) {

	function travel_tourist_loop_columns() {

		$travel_tourist_columns = get_theme_mod( 'travel_tourist_per_columns', 3 );

		return $travel_tourist_columns;
	}
}

/************************************************************************************/

add_filter( 'loop_shop_per_page', 'travel_tourist_per_page', 20 );

function travel_tourist_per_page( $travel_tourist_cols ) {

  	$travel_tourist_cols = get_theme_mod( 'travel_tourist_product_per_page', 9 );

	return $travel_tourist_cols;
}

/************************************************************************************/

add_filter( 'woocommerce_output_related_products_args', 'travel_tourist_products_args' );

function travel_tourist_products_args( $travel_tourist_args ) {

    $travel_tourist_args['posts_per_page'] = get_theme_mod( 'custom_related_products_number', 6 );

    $travel_tourist_args['columns'] = get_theme_mod( 'custom_related_products_number_per_row', 3 );

    return $travel_tourist_args;
}

/************************************************************************************/

/**
 * Custom logo
 */

function travel_tourist_custom_css() {
?>
	<style type="text/css" id="custom-theme-colors" >
        :root {
           
            --travel_tourist_logo_width: <?php echo absint(get_theme_mod('travel_tourist_logo_width')); ?> ;   
        }
        .site-branding img {
            max-width:<?php echo esc_html(get_theme_mod('travel_tourist_logo_width')); ?>px ;    
        }         
	</style>
<?php
}
add_action( 'wp_head', 'travel_tourist_custom_css' );

//////////////////////////////////////////////   Function for Translation Error   //////////////////////////////////////////////////////
function travel_tourist_enqueue_function() {

    /**
    * GET START.
    */
    require get_template_directory() . '/getstarted/travel_tourist_about_page.php';

    define('TRAVEL_TOURIST_FREE_SUPPORT',__('https://wordpress.org/support/theme/travel-tourist/','travel-tourist'));
    define('TRAVEL_TOURIST_PRO_SUPPORT',__('https://www.revolutionwp.com/support/revolution-wp/','travel-tourist'));
    define('TRAVEL_TOURIST_REVIEW',__('https://wordpress.org/support/theme/travel-tourist/reviews/','travel-tourist'));
    define('TRAVEL_TOURIST_BUY_NOW',__('https://www.revolutionwp.com/products/tourist-wordpress-theme','travel-tourist'));
    define('TRAVEL_TOURIST_LIVE_DEMO',__('https://demo.revolutionwp.com/travel-tourist-pro/','travel-tourist'));
    define('TRAVEL_TOURIST_PRO_DOC',__('https://demo.revolutionwp.com/wpdocs/travel-tourist-pro/','travel-tourist'));
    define('TRAVEL_TOURIST_LITE_DOC',__('https://demo.revolutionwp.com/wpdocs/travel-tourist-free/','travel-tourist'));
    
}
add_action( 'after_setup_theme', 'travel_tourist_enqueue_function' );



// Add admin notice
function travel_tourist_admin_notice() { 
    global $pagenow;
    $travel_tourist_theme_args      = wp_get_theme();
    $travel_tourist_meta            = get_option( 'travel_tourist_admin_notice' );
    $name            = $travel_tourist_theme_args->__get( 'Name' );
    $travel_tourist_current_screen  = get_current_screen();

    if( !$travel_tourist_meta ){
        if( is_network_admin() ){
            return;
        }

        if( ! current_user_can( 'manage_options' ) ){
            return;
        } 
        
        if($travel_tourist_current_screen->base != 'appearance_page_travel_tourist_guide' ) { ?>
            <div class="notice notice-success">
                <h2><?php esc_html_e('Hey, Thank you for installing Travel Tourist Theme!', 'travel-tourist'); ?><span><a class="info-link" href="<?php echo esc_url( admin_url( 'themes.php?page=travel-tourist-getstart-page' ) ); ?>"><?php esc_html_e('Click Here for more Details', 'travel-tourist'); ?></a></span></h2>
                <p class="dismiss-link"><strong><a href="?travel_tourist_admin_notice=1"><?php esc_html_e( 'Dismiss', 'travel-tourist' ); ?></a></strong></p>
            </div>
            <?php
        }

    }
}

add_action( 'admin_notices', 'travel_tourist_admin_notice' );

if( ! function_exists( 'travel_tourist_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function travel_tourist_update_admin_notice(){
    if ( isset( $_GET['travel_tourist_admin_notice'] ) && $_GET['travel_tourist_admin_notice'] = '1' ) {
        update_option( 'travel_tourist_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'travel_tourist_update_admin_notice' );

add_action('after_switch_theme', 'travel_tourist_setup_options');
function travel_tourist_setup_options () {
    update_option('travel_tourist_admin_notice', FALSE );
}

// changelog
function travel_tourist_get_changelog_from_readme() {
    $file_path = get_template_directory() . '/readme.txt'; // Adjust path if necessary

    if (file_exists($file_path)) {
        $content = file_get_contents($file_path);

        // Extract changelog section
        $changelog_start = strpos($content, "== Changelog ==");
        $changelog = substr($content, $changelog_start);

        // Split changelog into versions
        preg_match_all('/\*\s([\d\.]+)\s-\s(.+?)\n((?:\t-\s.+?\n)+)/', $changelog, $matches, PREG_SET_ORDER);
        
        return $matches;
    }
    return [];
}