<?php
defined('ABSPATH') or die("-1");

function Load_Css_Js_Files()
{
	echo '<script type="text/javascript" src="' . plugins_url( 'js/modernizr.custom.js', __FILE__ ) . '"></script>';
	echo '<script type="text/javascript" src="' . plugins_url( 'js/Bank-Mellat-Plugin.js', __FILE__ ) .'"></script>';
	echo '<link rel="stylesheet" type="text/css" href="' . plugins_url( 'css/Bank-Mellat-Plugin.css', __FILE__ ) .'" />';
}

add_action('admin_head', 'Load_Css_Js_Files');

// Default options values

$MBP_Options = array(
	'WaitMSG' => 'در حال اتصال به بانک ملت ...</br>لطفا کمی صبر کنید...',
	'CancelMSG' => 'شما از پرداخت هزينه انصراف داديد .',
	'ErrorMSG' => 'در تکمیل انتقال وجه به حساب مشکلی رخ داده است...<br /> مبلغ کسر شده از حساب حداکثر تا 72 دیگر به حساب شما برگشت داده خواهد شد.',
	'InvalidMSG' => 'این درخواست از درگاه ملت معتبر شناسایی نشد',
	'SuccessMSG' => 'پرداخت اینترنتی با موفقیت انجام شد',
	'Smstext' => 'پرداخت # با مبلغ $ با موفقیت انجام شد.',
	'Sender' => 'info@yoursite.ir',
	'Subject' => 'پرداخت وجه با موفقیت انجام شد!',
	'HeaderText' => '!خرید شما با موفقیت انجام شد',
	'EmailText' => 'با تشکر از شما پرداخت وجه با موفقیت انجام شد!',
	'FooterText' => 'این پیغام به صورت خودکار ارسال شده است، لطفا به آن پاسخ ندهید',
	'TextLink1' => 'صفحه نخست',
	'TextLink2' => 'درباره ما',
	'TextLink3' => 'تماس باما',
	'TextLink3' => 'تماس باما',
	'Form' => 'A',
	'Link1' => get_home_url() ,
	'SendSmS' => false,
);

if (is_admin()): // Load only if we are viewing an admin page
	function MBP_register_settings()
	{

		// Register settings and call sanitation functions

		register_setting('MBP_theme_options', 'MBP_Options', 'MBP_validate_options');
	}

	add_action('admin_init', 'MBP_register_settings');



	function MBP_theme_options()
	{

		// Add theme options page to the addmin menu

		// Add theme options page to the addmin menu
$settings = add_submenu_page( 'M_B_P',
		'پیکربندی تنظیمات افزونه درگاه ملت',
		'تنضیمات',
		'manage_options', 'M_B_P_Setting',
		'MBP_theme_options_page' );	}

	add_action('admin_menu', 'MBP_theme_options');

	// Function to generate options page

	function MBP_theme_options_page()
	{
		global $MBP_Options;
		if (!isset($_REQUEST['updated'])) $_REQUEST['updated'] = false; // This checks whether the form has just been submitted.
		 ?>

	<div class="wrap" style="background: #e7ecea;">

	<?php
		screen_icon();
		echo "<h2>تنظیمات افزونه درگاه ملت</h2>";

		// This shows the page's name and an icon if one has been provided

		 ?>

	<?php
		if (false !== $_REQUEST['updated']): ?>
	<div class="updated fade"><p><strong><?php
			_e('Options saved'); ?></strong></p></div>
	<?php
		endif; // If the form has just been submitted, this shows the notification
		 ?>

	<form method="post" action="options.php">

	<?php
		$settings = get_option('MBP_Options', $MBP_Options); ?>
	
	<?php
		settings_fields('MBP_theme_options');
		/* This function outputs some hidden fields required by the form,
		including a nonce, a unique number used to ensure the form has been submitted from the admin page
		and not somewhere else, very important for security */
?>
		
<section>
   <div class="tabs tabs-style-tzoid">
      <nav>
         <ul>
            <li><a href="#General" class="icon icon-general"><span>عمومی</span></a></li>
            <li><a href="#Email" class="icon icon-email"><span>ایمیل</span></a></li>
            <li><a href="#Sms" class="icon icon-sms"><span>اس ام اس</span></a></li>
            <li><a href="#Form" class="icon icon-form"><span>فرم</span></a></li>
         </ul>
      </nav>
      <div class="content-wrap">
         <section id="General">
            <table class="form-table" style="width:650px;">
               <!-- Grab a hot cup of coffee, yes we're using tables! -->
               <tr valign="top">
                  <th scope="row"><label for="TerminalNumber">شماره ترمینال</label></th>
                  <td>
                     <input id="TerminalNumber" name="MBP_Options[TerminalNumber]" type="text" value="<?php  esc_attr_e($settings['TerminalNumber']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="TerminalUser">نام کاربر ترمینال</label></th>
                  <td>
                     <input id="TerminalUser" name="MBP_Options[TerminalUser]" type="text" value="<?php  esc_attr_e($settings['TerminalUser']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="TerminalPass">کلمه عبور ترمینال</label></th>
                  <td>
                     <input id="TerminalPass" name="MBP_Options[TerminalPass]" type="text" value="<?php  esc_attr_e($settings['TerminalPass']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="WaitMSG">متن انتظار برای اتصال به بانک ملت</label></th>
                  <td>
                     <input id="WaitMSG" name="MBP_Options[WaitMSG]" type="text" value="<?php  esc_attr_e($settings['WaitMSG']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="CancelMSG">متن انصراف از پرداخت</label></th>
                  <td>
                     <input id="CancelMSG" name="MBP_Options[CancelMSG]" type="text" value="<?php  esc_attr_e($settings['CancelMSG']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="ErrorMSG">متن وقوع خطا در پرداخت</label></th>
                  <td>
                     <input id="ErrorMSG" name="MBP_Options[ErrorMSG]" type="text" value="<?php  esc_attr_e($settings['ErrorMSG']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="InvalidMSG">پیغام برای پرداخت های غیر معتبر</label></th>
                  <td>
                     <input id="InvalidMSG" name="MBP_Options[InvalidMSG]" type="text" value="<?php  esc_attr_e($settings['InvalidMSG']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="SuccessMSG">پیغام برای پرداخت های موفق</label></th>
                  <td>
                     <input id="SuccessMSG" name="MBP_Options[SuccessMSG]" type="text" value="<?php  esc_attr_e($settings['SuccessMSG']); ?>" />
                  </td>
               </tr>
     
              
            </table>
         </section>
         <section id="Email">
            <table class="form-table">
               <!-- Grab a hot cup of coffee, yes we're using tables! -->
               <tr valign="top">
                  <th scope="row"><label for="Sender">آدرس ایمیل ارسال کننده</label></th>
                  <td>
                     <input id="Sender" name="MBP_Options[Sender]" type="text" value="<?php  esc_attr_e($settings['Sender']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="Subject">موضوع ایمیل</label></th>
                  <td>
                     <input id="Subject" name="MBP_Options[Subject]" type="text" value="<?php  esc_attr_e($settings['Subject']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="LogoUrl">آدرس لوگو</label></th>
                  <td>
                     <input id="LogoUrl" name="MBP_Options[LogoUrl]" type="text" value="<?php  esc_attr_e($settings['LogoUrl']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="HeaderText">سربرگ ایمیل</label></th>
                  <td>
                     <input id="HeaderText" name="MBP_Options[HeaderText]" type="text" value="<?php  esc_attr_e($settings['HeaderText']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="EmailText">متن ایمیل</label></th>
                  <td>
                     <input id="EmailText" name="MBP_Options[EmailText]" type="text" value="<?php  esc_attr_e($settings['EmailText']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="FooterText">پاورقی ایمیل</label></th>
                  <td>
                     <input id="FooterText" name="MBP_Options[FooterText]" type="text" value="<?php  esc_attr_e($settings['FooterText']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="TextLink1">نام پیوند 1</label></th>
                  <td>
                     <input id="TextLink1" name="MBP_Options[TextLink1]" type="text" value="<?php  esc_attr_e($settings['TextLink1']); ?>" />
                  </td>
                  <th scope="row"><label for="Link1">آدرس پیوند 1</label></th>
                  <td>
                     <input id="Link1" name="MBP_Options[Link1]" type="text" value="<?php  esc_attr_e($settings['Link1']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="TextLink2">نام پیوند 2</label></th>
                  <td>
                     <input id="TextLink2" name="MBP_Options[TextLink2]" type="text" value="<?php  esc_attr_e($settings['TextLink2']); ?>" />
                  </td>
                  <th scope="row"><label for="Link2">آدرس پیوند 2</label></th>
                  <td>
                     <input id="Link2" name="MBP_Options[Link2]" type="text" value="<?php  esc_attr_e($settings['Link2']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="TextLink3">نام پیوند 3</label></th>
                  <td>
                     <input id="TextLink3" name="MBP_Options[TextLink3]" type="text" value="<?php  esc_attr_e($settings['TextLink3']); ?>" />
                  </td>
                  <th scope="row"><label for="Link3">آدرس پیوند 3</label></th>
                  <td>
                     <input id="Link3" name="MBP_Options[Link3]" type="text" value="<?php  esc_attr_e($settings['Link3']); ?>" />
                  </td>
               </tr>
            </table>
         </section>
         <section id="Sms">
            <table class="form-table" style="width:650px;">
               <tr valign="top">
                  <th scope="row">ارسال پیامک در زمان اتمام پرداخت</th>
                  <td>
                     <input type="checkbox" id="SendSmS" name="MBP_Options[SendSmS]" value="1" <?php checked( true, $settings['SendSmS'] ); ?> />
                     <label for="SendSmS">ارسال اس ام اس</label>
                  </td>
               </tr>             
			   <tr valign="top">
                  <th scope="row">سرویس دهنده پیامک</th>
                  <td>
						   <select dir="rtl"  name="sms_service">
						   <option value="melipayamak" <? if($settings['sms_service'] == 'melipayamak'){echo 'selected';} ?>>ملی پیامک</option>
						   <option value="hostiran" <? if($settings['sms_service'] == 'hostiran'){echo 'selected';} ?>>هاست ایران</option>
						   <option value="shabnam" <? if($settings['sms_service'] == 'shabnam'){echo 'selected';} ?>>شبنم</option>
						   <option value="mediana" <? if($settings['sms_service'] == 'mediana'){echo 'selected';} ?>>مدیانا</option>
						   <option value="fpayamak" <? if($settings['sms_service'] == 'fpayamak'){echo 'selected';} ?>>پیامکده</option>
						   <option value="diakosms" <? if($settings['sms_service'] == 'diakosms'){echo 'selected';} ?>>دیاکو پیامک</option>
						   <option value="samanpayamak" <? if($settings['sms_service'] == 'samanpayamak'){echo 'selected';} ?>>سامان پیامک</option>
						   <option value="idehsms" <? if($settings['sms_service'] == 'idehsms'){echo 'selected';} ?>>ایده اس ام اس</option>
						   <option value="banehsms" <? if($settings['sms_service'] == 'banehsms'){echo 'selected';} ?>>بانه اس ام اس</option>
						   <option value="irpayamak" <? if($settings['sms_service'] == 'irpayamak'){echo 'selected';} ?>>پیامک ایرانیان</option>
						   <option value="freersms" <? if($settings['sms_service'] == 'freersms'){echo 'selected';} ?>>فریر اس ام اس</option>
						   <option value="panizsms" <? if($settings['sms_service'] == 'panizsms'){echo 'selected';} ?>>پانیز اس ام اس</option>
						   <option value="mcisms" <? if($settings['sms_service'] == 'mcisms'){echo 'selected';} ?>>ایران اس ام اس</option>
						   <option value="smsclick" <? if($settings['sms_service'] == 'smsclick'){echo 'selected';} ?>>اس ام اس کلیک</option>
						   <option value="textsms" <? if($settings['sms_service'] == 'textsms'){echo 'selected';} ?>>Text Sms</option>
						   <option value="sgmsms" <? if($settings['sms_service'] == 'sgmsms'){echo 'selected';} ?>>سیگما اس ام اس</option>
						   <option value="persiansms" <? if($settings['sms_service'] == 'persiansms'){echo 'selected';} ?>>پرشین اس ام اس</option>
						   <option value="spadsms" <? if($settings['sms_service'] == 'spadsms'){echo 'selected';} ?>>اسـپــاد اس ام اس</option>
						   <option value="idehsms3000" <? if($settings['sms_service'] == 'idehsms3000'){echo 'selected';} ?>>ایده اس ام اس (3000)</option>
						   <option value="f2usms" <? if($settings['sms_service'] == 'f2usms'){echo 'selected';} ?>>f2u</option>
						   <option value="f2usms2" <? if($settings['sms_service'] == 'f2usms2'){echo 'selected';} ?>>Panel2u</option>
						   <option value="wstdsms" <? if($settings['sms_service'] == 'wstdsms'){echo 'selected';} ?>>WebStudio</option>
						   <option value="hezarnevis" <? if($settings['sms_service'] == 'hezarnevis'){echo 'selected';} ?>>hezarnevis</option>
						   </select>			

                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="AdminMobile">شماره موبایل مدیر وبسایت</label></th>
                  <td>
                     <input id="AdminMobile" name="MBP_Options[AdminMobile]" type="text" value="<?php  esc_attr_e($settings['AdminMobile']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="SMSuser">نام کاربری پنل پیامک</label></th>
                  <td>
                     <input id="SMSuser" name="MBP_Options[SMSuser]" type="text" value="<?php  esc_attr_e($settings['SMSuser']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="SMSpass">کلمه عبور پنل پیامک</label></th>
                  <td>
                     <input id="SMSpass" name="MBP_Options[SMSpass]" type="text" value="<?php  esc_attr_e($settings['SMSpass']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="SMSlinenum">شماره خط اختصاصی</label></th>
                  <td>
                     <input id="SMSlinenum" name="MBP_Options[SMSlinenum]" type="text" value="<?php  esc_attr_e($settings['SMSlinenum']); ?>" />
                  </td>
               </tr>
               <tr valign="top">
                  <th scope="row"><label for="Smstext">متن پیامک ارسالی</label></th>
                  <td>
                     <input id="Smstext" name="MBP_Options[Smstext]" type="text" value="<?php  esc_attr_e($settings['Smstext']); ?>" />
                  </td>
               </tr>
            </table>
         </section>
         <section id="Forn">
		             <table class="form-table" style="width:650px;">

                      <tr valign="top">
                  <th scope="row">فرم پرداخت</th>
                  <td>
                           <input type="radio" name="Form" value="A" <?php if($settings['Form'] =='A'){echo 'checked="checked"';} ?> />فرم1 </br>
                           <input type="radio" name="Form" value="B" <?php if($settings['Form']=='B'){echo 'checked="checked"';} ?> />فرم2</br>
                           <input type="radio" name="Form" value="C" <?php if($settings['Form']=='C'){echo 'checked="checked"';} ?> />فرم3
                  </td>
               </tr>
			               </table>

         </section>
      </div>
      <!-- /content -->
   </div>
   <!-- /tabs -->
</section>		
<p class="submit"><input type="submit" class="button-primary" value="ذخیره تغییرات" /></p>
</form>
</div>
<script>
   (function() {
   
   	[].slice.call( document.querySelectorAll( '.tabs' ) ).forEach( function( el ) {
   		new CBPFWTabs( el );
   	});
   
   })();
</script>
<?php
}

function MBP_validate_options($input)
{
	global $MBP_Options;
	$settings = get_option('MBP_Options', $MBP_Options);
	$input['TerminalNumber'] = wp_filter_nohtml_kses($input['TerminalNumber']);
	$input['TerminalUser'] = wp_filter_nohtml_kses($input['TerminalUser']);
	$input['TerminalPass'] = wp_filter_nohtml_kses($input['TerminalPass']);
	$input['WaitMSG'] = wp_filter_nohtml_kses($input['WaitMSG']);
	$input['CancelMSG'] = wp_filter_nohtml_kses($input['CancelMSG']);
	$input['ErrorMSG'] = wp_filter_nohtml_kses($input['ErrorMSG']);
	$input['InvalidMSG'] = wp_filter_nohtml_kses($input['InvalidMSG']);
	$input['SuccessMSG'] = wp_filter_nohtml_kses($input['SuccessMSG']);
	$input['Sender'] = wp_filter_nohtml_kses($input['Sender']);
	$input['Subject'] = wp_filter_nohtml_kses($input['Subject']);
	$input['LogoUrl'] = wp_filter_nohtml_kses($input['LogoUrl']);
	$input['HeaderText'] = wp_filter_nohtml_kses($input['HeaderText']);
	$input['EmailText'] = wp_filter_nohtml_kses($input['EmailText']);
	$input['FooterText'] = wp_filter_nohtml_kses($input['FooterText']);
	$input['TextLink1'] = wp_filter_nohtml_kses($input['TextLink1']);
	$input['TextLink2'] = wp_filter_nohtml_kses($input['TextLink2']);
	$input['TextLink3'] = wp_filter_nohtml_kses($input['TextLink3']);
	$input['Link1'] = wp_filter_nohtml_kses($input['Link1']);
	$input['Link2'] = wp_filter_nohtml_kses($input['Link2']);
	$input['Link3'] = wp_filter_nohtml_kses($input['Link3']);
	$input['SendSmS'] = wp_filter_nohtml_kses($input['SendSmS']);
	$input['AdminMobile'] = wp_filter_nohtml_kses($input['AdminMobile']);
	$input['SMSuser'] = wp_filter_nohtml_kses($input['SMSuser']);
	$input['SMSpass'] = wp_filter_nohtml_kses($input['SMSpass']);
	$input['SMSlinenum'] = wp_filter_nohtml_kses($input['SMSlinenum']);
	$input['Smstext'] = wp_filter_nohtml_kses($input['Smstext']);
	$input['sms_service'] = wp_filter_nohtml_kses($_POST['sms_service']);
	$input['Form'] = wp_filter_nohtml_kses($_POST['Form']);
	return $input;

}
endif; // EndIf is_admin()