<?php
defined('ABSPATH') or die("-1");
/**
 * Plugin Name:  درگاه پرداخت بانک ملت
 * Description: افزونه درگاه پرداخت بانک ملت | برای استفاده از افزونه کدمیانبر [M_B_P_SC] را در پست یا برگه مورد نظر خود وارد کنید.
 * Version: 1.0
 * Author: Wp-Beginner.ir
 * Author URI: http://wp-beginner.ir
 * License: تمامي حقوق اين افزونه براي گروه Wp-Beginner محفوظ مي باشد
 */

global $M_B_P_db_version;
$M_B_P_db_version = '1.0';

function M_B_P_install() {
	global $wpdb;
	global $M_B_P_db_version;

	$table_name = $wpdb->prefix . 'M_B_P_Orders';
	$charset_collate = '';

	if ( ! empty( $wpdb->charset ) ) {
	  $charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
	}

	if ( ! empty( $wpdb->collate ) ) {
	  $charset_collate .= " COLLATE {$wpdb->collate}";
	}

	$sql = "CREATE TABLE $table_name (
   id int(40) NOT NULL AUTO_INCREMENT,
  status varchar(65)   NOT NULL,
  price int(40) NOT NULL,
  date varchar(20)   NOT NULL,
  ip varchar(65)   NOT NULL,
  orderid varchar(80)   NOT NULL,
  referenceId varchar(80)   NOT NULL  ,
  refid varchar(70)   NOT NULL,
  settle varchar(80)  NOT NULL,
  namefamily varchar(65)   NOT NULL,
  phone varchar(65)   NOT NULL,
  des varchar(65)   NOT NULL,
  email text   NOT NULL,
  PRIMARY KEY (id)
	) $charset_collate;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );

	add_option( 'M_B_P_db_version', $M_B_P_db_version );
}


register_activation_hook( __FILE__, 'M_B_P_install' );

add_action('admin_menu', 'M_B_P_Menu');
add_action('template_redirect', 'Download_Orders');

function Download_Orders()
{
	if ($_SERVER['REQUEST_URI'] == '/orders/orders_export-' . date('Y-m-d') * 10 . '.html') {
		if (current_user_can('manage_options')) {
			header('Content-Type: text/html; charset=utf-8',true,200);
			header("Content-Disposition: attachment; filename=Orders.html");
			header("Pragma: no-cache");
			header("Expires: 0");
				global $wpdb;
 
$getorder = $wpdb->get_results( " SELECT * FROM wp_M_B_P_Orders order by id" );
 if ( $getorder )
{
echo'
<!DOCTYPE html>
<html>
   <head>
      <meta charset="UTF-8">
      <meta name="author" content="plugin bank-mellat">
      <style>html{direction:rtl;text-align:right;font-family:sans-serif;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}body{margin:0}article,aside,details,figcaption,figure,footer,header,hgroup,main,menu,nav,section,summary{display:block}audio,canvas,progress,video{display:inline-block;vertical-align:baseline}audio:not([controls]){display:none;height:0}[hidden],template{display:none}a{background-color:transparent}a:active,a:hover{outline:0}abbr[title]{border-bottom:1px dotted}b,strong{font-weight:700}dfn{font-style:italic}h1{font-size:2em;margin:.67em 0}mark{background:#ff0;color:#000}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sup{top:-.5em}sub{bottom:-.25em}img{border:0}svg:not(:root){overflow:hidden}figure{margin:1em 40px}hr{-moz-box-sizing:content-box;-webkit-box-sizing:content-box;box-sizing:content-box;height:0}pre{overflow:auto}code,kbd,pre,samp{font-family:monospace,monospace;font-size:1em}button,input,optgroup,select,textarea{color:inherit;font:inherit;margin:0}button{overflow:visible}button,select{text-transform:none}button,html input[type="button"],input[type="reset"],input[type="submit"]{-webkit-appearance:button;cursor:pointer}button[disabled],html input[disabled]{cursor:default}button::-moz-focus-inner,input::-moz-focus-inner{border:0;padding:0}input{line-height:normal}input[type="checkbox"],input[type="radio"]{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;padding:0}input[type="number"]::-webkit-inner-spin-button,input[type="number"]::-webkit-outer-spin-button{height:auto}input[type="search"]{-webkit-appearance:textfield;-moz-box-sizing:content-box;-webkit-box-sizing:content-box;box-sizing:content-box}input[type="search"]::-webkit-search-cancel-button,input[type="search"]::-webkit-search-decoration{-webkit-appearance:none}fieldset{border:1px solid silver;margin:0 2px;padding:.35em .625em .75em}legend{border:0;padding:0}textarea{overflow:auto}optgroup{font-weight:700}table{border-collapse:collapse;border-spacing:0}td,th{padding:0}.responstable{margin:1em 0;width:100%;overflow:hidden;background:#FFF;color:#024457;border-radius:10px;border:1px solid #167F92}.responstable tr{border:1px solid #D9E4E6}.responstable tr:nth-child(odd){background-color:#EAF3F3}.responstable th{display:none;border:1px solid #FFF;background-color:#167F92;color:#FFF;padding:1em}.responstable th:first-child{display:table-cell;text-align:center}.responstable th:nth-child(2){display:table-cell}.responstable th:nth-child(2) span{display:none}.responstable th:nth-child(2):after{content:attr(data-th)}@media (min-width: 480px){.responstable th:nth-child(2) span{display:block}.responstable th:nth-child(2):after{display:none}}.responstable td{display:block;word-wrap:break-word;max-width:7em}.responstable td:first-child{display:table-cell;text-align:center;border-right:1px solid #D9E4E6}@media (min-width: 480px){.responstable td{border:1px solid #D9E4E6}}.responstable th,.responstable td{text-align:right;margin:.5em 1em}@media (min-width: 480px){.responstable th,.responstable td{display:table-cell;padding:1em}}body{padding:0 2em;font-family:Arial,sans-serif;color:#024457;background:#f2f2f2}h1{font-family:Verdana;font-weight:400;color:#024457}h1 span{color:#167F92}</style>
   </head>
   <body>
      <h1>گزارشات تراکنش های انجام شده</span></h1>
      <table class="responstable">
         <tr>
            <th>#</th>
            <th>نام و نام خانوادگي</th>
            <th>آدرس ايميل</th>
            <th>شماره تلفن</th>
            <th>توضيحات</th>
            <th>وضعيت پرداخت</th>
            <th>ستل</th>
            <th>تاريخ</th>
            <th>آي پي</th>
            <th>مبلغ(ريال)</th>
            <th>رسيد ديجيتالي سفارش</th>
            <th>شماره سفارش</th>
            <th>شماره تراکنش</th>
         </tr>
';
foreach ($getorder as $order) { 
      echo  $actions='
	   <tr>
            <td>'. $order->id.'</td>
            <td>'.$order->namefamily.'</td>
            <td>'.$order->email.'</td>
            <td>'. $order->phone.'</td>
            <td>'.$order->des.'</td>
            <td>'.$order->status.'</td>
            <td>'.$order->settle.'</td>
            <td>'.$order->date.'</td>
            <td>'.$order->ip.'</td>
            <td>'.$order->price.'</td>
            <td>'.$order->referenceId.'</td>
            <td>'.$order->orderid.'</td>
            <td>'.$order->refid.'</td>
         </tr>
		';
}
	echo '
	    </table>
		تاریخ گزارش گیری: '.date('Y-m-d').'
   </body>
</html>
';
}		
	exit();

		}
		else {
			echo '-1';echo "<script>window.close();</script>";
		}
	}
}
function M_B_P_Menu()
{
	add_menu_page('درگاه پرداخت بانک ملت', 'درگاه ملت', 'manage_options', 'M_B_P', 
	'M_B_P_Func', plugins_url('bank-mellat/images/bankmellat.png') , 'my-top-level-slug');
	

	$orders = add_submenu_page( 'M_B_P',
		'لیست گزارشات پرداخت ها',
		'گزارشات',
		'manage_options', 'M_B_P',
		'M_B_P_Func' );

}


include_once('settings.php');


include_once('shortcode.php');


require_once ('orders.php');

function M_B_P_Func()
{
	global $wpdb;
	$table = new Orders_List();
	$table->prepare_items();
	$message = '';
	if ('delete' === $table->current_action()) {
		$message = '<div class="updated below-h2" id="message"><p>' . sprintf('%d مورد حذف شدند!' , count($_REQUEST['id'])) . '</p></div>';
	}

?>

<style>
.MBP_overlay{position:absolute;top:0;bottom:0;left:0;right:0;background:rgba(0,0,0,0.5);transition:opacity 200ms;visibility:hidden;z-index:999;opacity:0}.MBP_overlay.light{background:rgba(255,255,255,0.5)}.MBP_overlay .cancel{position:absolute;width:100%;height:100%;cursor:default}.MBP_overlay:target{visibility:visible;opacity:1}.MBP_popup{margin:75px auto;padding:20px;background:#fff;border:1px solid #666;width:500px;box-shadow:0 0 50px rgba(0,0,0,0.5);position:relative}.MBP_light .MBP_popup{border-color:#aaa;box-shadow:0 2px 10px rgba(0,0,0,0.25)}.MBP_popup h2{margin-top:0;color:#666;font-family:"Trebuchet MS",Tahoma,Arial,sans-serif}.MBP_popup .MBP_close{position:absolute;width:20px;height:20px;top:20px;right:20px;opacity:.8;transition:all 200ms;font-size:24px;font-weight:700;text-decoration:none;color:#666}.MBP_popup .MBP_close:hover{opacity:1}.MBP_popup .MBP_content{max-height:400px;overflow:auto}.MBP_popup p{margin:0 0 1em}.MBP_popup p:last-child{margin:0}
</style>
<div class="wrap">
   <div id="icon-users" class="icon32"><br/></div>
   <div class="icon32 icon32-posts-post" id="icon-edit"><br /></div>
   <h2>گزارشات تراکنش های انجام شده</h2>
   <div class="stat-container">
      <div class="stat-holder">
         <div class="stat">							
            <span id="total"><?php	global $wpdb;
 $results = mysql_query("SELECT SUM(price) AS priceCount  FROM wp_M_B_P_Orders where status='تکمیل شده است'");$rows = mysql_fetch_row($results);echo $rows[0];?></span>							
            مجموع مبالغ پرداخت هاي موفق						
         </div>
         <!-- /stat -->						
      </div>
      <!-- /stat-holder -->
      <div class="stat-holder">
         <div class="stat">							
            <span><?php 	global $wpdb;
$GetAllpay = mysql_query("SELECT * FROM wp_M_B_P_Orders "); $num_GetAllpay = mysql_num_rows($GetAllpay); echo $num_GetAllpay; ?></span>							
            مجموع پرداخت ها						
         </div>
         <!-- /stat -->						
      </div>
      <!-- /stat-holder -->
      <div class="stat-holder">
         <div class="stat">							
            <span><?php 	global $wpdb;
$getyespay = mysql_query("SELECT * FROM wp_M_B_P_Orders where status='تکمیل شده است'"); $num_getyespay = mysql_num_rows($getyespay); echo $num_getyespay; ?></span>							
            پرداخت هاي موفق							
         </div>
         <!-- /stat -->						
      </div>
      <!-- /stat-holder -->
      <div class="stat-holder">
         <div class="stat">							
            <span><?php 	global $wpdb;
$getnopay = mysql_query("SELECT * FROM wp_M_B_P_Orders where status='خیر'"); $num_getnopay = mysql_num_rows($getnopay); echo $num_getnopay; ?></span>							
            پرداخت هاي ناموفق							
         </div>
         <!-- /stat -->						
      </div>
      <!-- /stat-holder -->
   </div>
   <?php
      echo $message; ?>
   <form id="persons-table" method="GET">
      <input type="hidden" name="page" value="<?php
         echo $_REQUEST['page'] ?>"/>
      <?php
         $table->display() ?>
   </form>
</div>

<? 

}